#ifndef CHAINEDHASHTRP_H
#define CHAINEDHASHTRP_H

#include "DList.h" //includes sstream.
#include <vector>
using std::vector;

template <class I> //REQ I must have operator << // .str();

class ChainedHash //MorphedValli
{
public:
    class iterator
    {
        typename DList<I>::iterator list_iter;

        iterator(const typename DList<I>::iterator& l_iter)
            :list_iter(l_iter){}

        friend class ChainedHash<I>; //MorphedValli<I>

    public:
        iterator(const iterator& other)
            :list_iter(other.list_iter){}

        iterator& operator=(const iterator& rhs)
        {
            list_iter = rhs.list_iter;
            return *this;
        }

        I& operator*() const
        {
            return *list_iter;
        }

        iterator& operator++()
        {
            ++list_iter;
            return *this;
        }

        iterator operator++(int)
        {
            iterator oldMe = *this;
            list_iter++;
            return oldMe;
        }

        bool operator==(const iterator& rhs) const
        {
            return list_iter == rhs.list_iter;
        }

        bool operator!=(const iterator& rhs) const
        {
            return list_iter != rhs.list_iter;
        }
    };

private:
    DList<I> list;
    vector<iterator> vec;
    size_t n, buckets;

public:

    explicit ChainedHash(size_t buckets = 1000000) //MorphedValli(size_t... etc
        :list(DList<I>())
        ,vec(vector<iterator>())
        ,n(0), buckets(buckets)
    {
        for (size_t bucket = 0; bucket < buckets; bucket++)
        {
            iterator iter = iterator(list.insert(list.end(), I()));
            vec.push_back(iter);
        }
        vec.push_back(iterator(list.end()));
    }

    ~ChainedHash(){} // ~MorphedVallie(){}

    iterator begin() const
    {
        return iterator(list.begin());
    }

    iterator end() const
    {
        return iterator(list.end());
    }

    iterator find(const I& item) const
    {
        // To do ... similar to insert
        size_t h = hash(item) % buckets;
        for (iterator iter = vec[h]; iter != vec[h+1]; iter++)
        {
            if (*iter == item)
            {return iter;}
        }
        return end();
        //returning the item and and bool b = true; if there is no item it returns bool b = false
    }
    iterator insert(const I& item)
    {
        size_t h = hash(item) % buckets;
        for (iterator iter = vec[h]; iter != vec[h+1]; iter++)
            if (*iter == item)
                return iter;
        ++n;
        return iterator(list.insert(vec[h+1].list_iter, item));
    }

    size_t size() const
    {
        return n;
    }

    bool empty() const
    {
        return size() == 0;
    }

    string str() const
    {
        return list.toString();
    }

    size_t hash(const I& item) const // uses output operator << on I.
    {
        //ostringstream out;
        //out << item;
        string x = item.toString();
        for(size_t i = 0, hash = 0; i < x.size(); i++)
        {hash = hash * 31 + x[i]; return hash;}
    }
};

#endif // CHAINEDHASHTRP_H
