#include <iostream>
#include <string>
#include <vector>
#include <fstream>
using namespace std;

class StringDeque
{
public:
vector<string>* elements;
int frontItem;
int rearSpace;
int upperBound;

public:
StringDeque(int guaranteedCapacity) 
: elements(new vector<string>(2*guaranteedCapacity)),

frontItem(guaranteedCapacity),
rearSpace(guaranteedCapacity),
upperBound(2*guaranteedCapacity) {}


virtual bool isEmpty() const 
{return frontItem == rearSpace;}
virtual bool isFull() const
{return rearSpace == upperBound || frontItem == 0;}
virtual int size() const
{return rearSpace - frontItem;}

virtual string popRear()
{
if(isEmpty())
{
cout << "Later we'll define and throw an EmptyQException" << endl;
return "";
}
else
{
return elements->at(--rearSpace);
}
}

virtual string popFront()
{
if(isEmpty())
{
cout << "Later we'll define and throw an EmptyQException" << endl;
return "";
}
else
{
return elements->at(frontItem++);
}
}

virtual void pushFront(string newItem)
{
elements->at(--frontItem) = newItem;
}

virtual void pushRear(string newItem)
{
elements->at(rearSpace++) = newItem;
}

virtual string toString() const
{
string out = "";
for(int i = frontItem; i < rearSpace; i++)
{
out += elements->at(i) + " ";
}
return out;
}
};

int main()
{
StringDeque* sd = new StringDeque(100);
sd->pushFront("oh");
sd->pushFront("say");
sd->pushFront("can");
sd->pushFront("you");
sd->pushFront("see");
sd->pushRear("any");
sd->pushRear("bad bugs");
sd->pushRear("on");
sd->pushRear("me?");
cout << sd->toString() << endl;
string pop2 = sd->popRear() + " " + sd->popRear();
cout << pop2 + " , did this print in the right order?" << endl;
sd->pushFront("I");
cout << "Final deque: " + sd->toString() << endl;
return 0; }

/* There is a difference between C++ and the Java implementation of Deque.
C++ does not make the guarentees that Java does as per method implementations.
Java may make sure that methods are read left to right while C++ does not.
*/
