#ifndef STACKPAIR_H
#define STACKPAIR_H

#include <vector>
using namespace std;

template <class T>

class StackPair
{
	vector<T> elements;
	int rearSpace;

public:
	StackPair(int guaranteedCapacity);
	bool isEmpty();
	T popRear();
	void pushRear(T newItem);
};
template <class T>
StackPair<T>::StackPair(int guaranteedCapacity)
{
	elements = vector<T>(guaranteedCapacity);
	rearSpace = 0;
}

template <class T>
bool StackPair<T>::isEmpty()
{
	return rearSpace == 0;
}

template <class T>
T StackPair<T>::popRear()
{
	return elements[--rearSpace];
}

template <class T>
void StackPair<T>::pushRear(T newItem)
{
	elements[rearSpace++] = newItem;
}

#endif // STACKPAIR_H
