#ifndef STACKPAIRTRP_H
#define STACKPAIRTRP_H

#include <iostream>
#include <vector>
#include <string>
#include <sstream>

using namespace std;

template <class T> class StackPairTRP {

    vector<T>* elements;
    int frontItem;
    int rearSpace;
    int upperBound;

public:

    StackPairTRP(int guaranteedCapacity);
    virtual bool isEmpty() const;
    virtual bool isFull() const;
    virtual int size() const;
    virtual T popRear();
    virtual T popFront();
    virtual void pushFront(T newItem);
    virtual void pushRear(T newItem);
    virtual string toString();
};

template <class T> StackPairTRP<T>::StackPairTRP(int guaranteedCapacity) {
        elements = new vector<T>(2 * guaranteedCapacity);
        frontItem = guaranteedCapacity;
        rearSpace = guaranteedCapacity;
        upperBound = 2 * guaranteedCapacity;
}
template <class T> bool StackPairTRP<T>::isEmpty() const {return frontItem == rearSpace;}
template <class T> bool StackPairTRP<T>::isFull() const {return (frontItem == 0 && rearSpace == upperBound);}
template <class T> int StackPairTRP<T>::size() const {return rearSpace - frontItem;}

template <class T> T StackPairTRP<T>::popRear() {
        try {
            if (isEmpty()) {
                throw 20;
            } else {
                return elements->at(--rearSpace);
            }
        }
        catch (int e) {
            cerr << "Cannot call popRear() on an empty StackPair object." << endl;
        }
    }

template <class T> T StackPairTRP<T>::popFront() {
        try {
            if (isEmpty()) {
                throw 20;
            } else {
                return elements->at(frontItem++);
            }
        }
        catch (int e) {
            cerr << "Cannot call popFront() on an empty StackPair object." << endl;
        }
    }

template <class T> void StackPairTRP<T>::pushRear(T newItem) {
        try {
            if (frontItem == 0) {
                throw 20;
            } else {
                elements->at(rearSpace++) = newItem;
            }
        }
        catch (int e) {
            cerr << "Rear stack is full; cannot call pushRear()." << endl;
        }
    }

template <class T> void StackPairTRP<T>::pushFront(T newItem) {
        try {
            if (rearSpace == upperBound) {
                throw 20;
            } else {
                elements->at(--frontItem) = newItem;
            }
        }
        catch (int e) {
            cerr << "Front stack is full; cannot call pushFront()." << endl;
        }
    }

template <class T> string StackPairTRP<T>::toString() {
    stringstream out;
    for (int i = frontItem; i < rearSpace; i++) {
        out << elements->at(i) << " ";
    }
    return out.str();
}

#endif // STACKPAIRTRP_H
