#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include "ValliTRP.h"
/*Author: Thomas Papp*/
using namespace std;

string wordturn(string word) //function to turn words
{
        string turned = word; //instantiating turned word
        string newWord; //will be used to return the turned word
        string partword1;
        string partword2;
        int len = turned.length(); //shortening length
        if (len%2 == 0) {
                for (int i=len/2 - 1; i >= 0; i--) {
                        partword1 = partword1+turned[i];
                }
                for (int j=len - 1; j>=len/2; j--) {
                        partword2 = partword2+turned[j];
                }
                newWord = partword1 + partword2;
        }
        else if (len%2 == 1) {
                for (int i=len/2; i >= 0; i--) {
                        partword1 = partword1+turned[i];
                }
                for (int j=len - 1; j>=len/2; j--) {
                        partword2 = partword2+turned[j];
                }
                newWord = partword1 + partword2; //creates the newWord
        }
        return newWord;
}
bool binsearch(const vector<string>& dictVect, const string& tWord) { //does a binary search
        string newWord = wordturn(tWord);
        int first = 0;
        int last = dictVect.size()-1;

        if (last<first) {
                return false;
        }
        if(tWord.length() > 3) { // REQ: Word must be longer than 3 characters.
                while (first<=last) { // REQ: First index has to be less than or equal to last index.
                        int middle = (first+last)/2;
                        int comp = newWord.compare(dictVect[middle]);

                        if(comp==0) { //REQ: If turned word is same as word in inputted file (dictVect).
                                return true;
                        }
                         if(comp>0) {
                                first = middle + 1;
                        }
                        if(comp<0) {
                                last = middle - 1;
                        }
                }
				       }
        return false;
}

int main(int argC, char* argV[])
{
	if (argC == 1){cout<<"No input file detected."<<endl;
return 0;}
        if (argC > 1)
        {
                ifstream fin(argV[1]);
                if (fin.is_open())
                {
                        vector<string> original_words;
                        valli<string> turnd_words;
                        while (!fin.eof())
                        {
                                string word;
                                fin >> word;
                                if (word.length() > 3)
                                {
                                        original_words.push_back(word);
                                        string turnd = wordturn(word);
					if(binsearch(original_words, turnd))                                        
					{turnd_words.insert(turnd);}
                                }
                        }
                        fin.close();

                        ofstream fout("turnd.txt");
                        for (valli<string>::iterator i = turnd_words.begin(); i != turnd_words.end(); i++)
                                fout << *i << endl;
                        fout.close();
                }
        }
        return 0;
}
