#include <iostream>
#include <vector>
#include <string>

using namespace std;

class StringDeque {
	vector<string>* elements;
	int frontItem;
	int rearSpace;
	int upperBound;


public:
	
	StringDeque(int guaranteedCapacity):
		elements (new vector<string> (2*guaranteedCapacity)),
		frontItem (guaranteedCapacity),
		rearSpace (guaranteedCapacity),
		upperBound (2*guaranteedCapacity) {}
		
	
	const bool empty() { return frontItem == rearSpace; }
	const bool full() { return rearSpace == upperBound || frontItem == 0; }
	int size() {return rearSpace - frontItem; }

	virtual string popRear(){
		if (empty()){
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return "";}
		else { return elements->at(--rearSpace); }
	}
	
	virtual string popFront(){
		if (empty()) {
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return ""; }
		else { return elements->at(frontItem++); }
	}

	virtual void pushFront(string newItem){
		elements->at(--frontItem) = newItem;
	}

	virtual void pushRear(string newItem){
		elements->at(rearSpace++) = newItem;
	}

	virtual string toString(){
		string out = "";
		for (int i = frontItem; i < rearSpace; i++) {
			out += elements->at(i) + " ";
		}
		return out; }

};

	int main(){
		StringDeque *sd = new StringDeque(100);
		sd->pushFront("oh");
		sd->pushFront("say");
		sd->pushFront("can");
		sd->pushFront("you");
		sd->pushFront("see");
		sd->pushRear("any");
		sd->pushRear("bad bugs");
		sd->pushRear("on");
		sd->pushRear("me?");
		cout << sd->toString();
		string pop2 = sd->popRear() + " " + sd->popRear();
		cout << pop2 + ", did this print in the right order?";
		sd->pushFront("I");
		cout << "Final deque: " + sd->toString();
		return 0;
	}

	/**There was only one difference I found in the C++ program in contrast to the Java one.
	*The difference is when the program uses the popRear method. I think that the C++ program
	*reads from right to left and the Java program reads from left to right. This makes the
	*output slightly different than the Java one.
	*/

