//Zachary Esmaelzada 50039754

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H_

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
   vector<T>* elements;
   ChunkNode* prev;          //optional, to make doubly-linked list

   ChunkNode<T>* next;       //typename is illegal here
   //FlexArray<T>* myList;   //unnecessary?
   size_t mySize;            //INV: # of elements actually stored
   friend class FlexArray<T>;
   friend class FlexArray<T>::iterator;   //begin lab with this line

 public:
   ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
                                      ChunkNode<T>* myNext)
    : elements(new vector<T>()), prev(myPrev), next(myNext),
      myList(myList), mySize(0)
   { }
};

template <class T>
class FlexArray {
   ChunkNode<T>* firstNode;
   ChunkNode<T>* endNode;
   size_t nodeCap;
   size_t numNodes;
   //friend class ChunkNode<T>;   //IMHO not necessary

   //CLASS INV: endNode is a dummy node, used as target for iterations.
   //firstNode is a real node only when the FlexArray is nonempty (Optional change)
   //Empty is size() == 0, rather than endNode == firstNode.
   //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
   //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
   //MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

 public:

   explicit FlexArray<T>(size_t nodeCap)
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(nodeCap)
    , numNodes(1)
   { }

   FlexArray<T>()
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(40)
    , numNodes(1)
   { }

   class iterator { const FlexArray<T>* myFlex;
	   ChunkNode<T>* node;
	   size_t localIndex;

	   friend class FlexArray<T>;

	   iterator(const FlexArray<T>* holder, ChunkNode<T>* node, size_t index) : myFlex(holder), node(node), localIndex(index){}
   public:
	   T& operator*(){
		   if (node == NULL || node == myFlex->endNode){
			   throw runtime_error("Attempt to derefference end iterator");
		   }
		   else{
			   return node->elements->at(localIndex);
		   }

	   }
	  
	   iterator& operator++(){
		   if (node == myFlex->endNode){ //dummy node
			   throw RangeEx("Attempt to move past end position");
		   }
		   else if (node == NULL){
			   node = myFlex->firstNode;
				   localIndex = 0;

		   }
		   else{
			   localIndex++;
			   if (localIndex == node->mySize){
				   node = node->next;
				   localIndex = 0;
			   }
		   }
		   return *this;
	   }

	   iterator operator++(int ignored){
		   iterator copy = *this;
		   operator++();
		   return copy;
	   }

	   bool operator==(const iterator& rhs)const{
		   return node == rhs.node && localIndex == rhs.localIndex && myFlex == rhs.myFlex;
	   }
	   bool operator!=(const iterator& rhs)const{
		   return(!(*this == rhs));
	   }
   };
   iterator begin(){ return iterator(this, firstNode, 0); }
   iterator end()	{ return iterator(this, endNode, 0); }
   iterator rbegin(){
	   return iterator(this, endNode->prev, endNode->prev->mySize - 1);
   }

   /*void insert(size_t i, const T& item){
	   ChunkNode<T>* curr = firstNode;
	   int globalIndex = 0;
	   int localIndex = 0;
	   for(int j = 0; j < curr->mySize; j++){
		   globalIndex++;
		   localIndex++;
		   if (globalIndex == i){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   curr->elements->insert(itr, item);
		   }
		   else if (j == curr->mySize){
			   curr->next;
			   localIndex = 0;
		   }
	   }
	   if (i = nodeCap){
		   localIndex = 0;
		   FlexArray<T>(20) first;
		   FlexArray<T>(20) second;
		   while(curr->elements->at(localIndex) != (nodeCap/2) - 1){
			   curr->elements->at(localIndex) == first->elements->at(localIndex);
			   localIndex++; // first 20 items in first node split.
		   }
		   while(curr->elements->at(localIndex) < nodeCap){
			   curr->elements->at(localIndex) == second->elements->at(localIndex);
			   localIndex++; // next 20 items in second node split.
		   }
		   if (curr->elements->at(localIndex) = (nodeCap/2) - 1){
			   first->elements->at(localIndex)->insert(itr, item);
			   // inserts item to the last index of the first part of split node.
		   }
	   }
   }

   void erase(size_t i){
	   ChunkNode<T>* curr = firstNode;
	   int globalIndex = 0;
	   int localIndex = 0;
	   for(int j = 0; j < curr->mySize; j++){
		   globalIndex++;
		   localIndex++;
		   if (globalIndex == i){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   curr->elements->at(itr)->clear();
		   }
		   else if (j == curr->mySize){
			   curr->next;
			   localIndex = 0;
		   }
	   }
   }
   */
   T& at(size_t i){
	   ChunkNode<T>* curr = firstNode;
	   int globalIndex = 0;
	   int localIndex = 0;
	   for(int j = 0; j < curr->mySize; j++){
		   globalIndex++;
		   localIndex++;
		   if (globalIndex == i){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   return itr;
		   }
		   else if (j == curr->mySize){
			   curr->next;
			   localIndex = 0;
		   }
	   }
   }
   //at, insert, erase, operator[] etc. methods go here...

    iterator insert(iterator beforeMe, const T& item){
	   ChunkNode<T>* curr = firstNode;
	   //int globalIndex = 0;
	   int localIndex = 0;
	   for(int j = 0; j < curr->mySize; j++){
		   //globalIndex++;
		   localIndex++;
		   if (curr->elements->begin() + localIndex == nodeCap){
			   localIndex = 0;
			   FlexArray<T>(20) first;
			   FlexArray<T>(20) second;
			   while(curr->elements->at(localIndex) != (nodeCap/2) - 1){
			   curr->elements->at(localIndex) == first->elements->at(localIndex);
			   localIndex++; // first 20 items in first node split.
		       }
			   if (curr->elements->at(localIndex) = (nodeCap/2) - 1){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   first->elements->at(localIndex)->insert(itr, item);
			   // inserts iterator to the end of the first node split.
			   }
		       while(curr->elements->at(localIndex) < nodeCap && curr->elements->at(localIndex) > (nodeCap/2) - 1){
			   curr->elements->at(localIndex) == second->elements->at(localIndex);
			   localIndex++; // next 20 items in second node split.
		       }
			   return itr;
		   }

		   else if (curr->elements->begin() + localIndex == beforeMe){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   curr->elements->insert(itr, item);
			   return itr;
		   }
		   else if (j == curr->mySize){
			   curr->next;
			   localIndex = 0;
		   }
	   }
	   /*if ( = nodeCap){
		   localIndex = 0;
		   FlexArray<T>(20) first;
		   FlexArray<T>(20) second;
		   while(curr->elements->at(localIndex) != (nodeCap/2) - 1){
			   curr->elements->at(localIndex) == first->elements->at(localIndex);
			   localIndex++; // first 20 items in first node split.
		   }
		   while(curr->elements->at(localIndex) < nodeCap){
			   curr->elements->at(localIndex) == second->elements->at(localIndex);
			   localIndex++; // next 20 items in second node split.
		   }
		   if (curr->elements->at(localIndex) = (nodeCap/2) - 1){
			   first->elements->at(localIndex)->insert(itr, item);
			   // inserts item to the last index of the first part of split node.
		   }*/
	   }

	iterator erase(iterator me){
	   ChunkNode<T>* curr = firstNode;
	   //int globalIndex = 0;
	   int localIndex = 0;
	   for(int j = 0; j < curr->mySize; j++){
		   //globalIndex++;
		   localIndex++;
		   if (curr->elements->begin() + localIndex == me){
			   vector<T>::iterator itr = curr->elements->begin() + localIndex;
			   curr->elements->at(itr)->clear();
			   return itr->next;
		   }
		   else if (j == curr->mySize){
			   curr->next;
			   localIndex = 0;
		   }
	   }
	}

	template <typename T>
		ostream& operator<< (ostream& out, const FlexArray<T>& ds) {
			out << ds.toString();
			return out;
		}
	template <typename T>
		ostream& operator<< (ostream& out, const FlexArray<T>*& dsp) {
		out << dsp->toString();
		return out;
		}

}; // FlexArray Class end ().

#endif

