#ifndef PEEK_DEQUE__H
#define PEEK_DEQUE__H

#include <iostream>
#include <vector>
#include <string>
#include <fstream>

using namespace std;

class StringDeque {
	
protected:
	vector<string>* elements;
	int frontItem;
	int rearSpace;
	int upperBound;

public:
	
	StringDeque(int guaranteedCapacity):
		elements (new vector<string> (2*guaranteedCapacity)),
		frontItem (guaranteedCapacity),
		rearSpace (guaranteedCapacity),
		upperBound (2*guaranteedCapacity) { }
		
	
	const bool empty() { return frontItem == rearSpace; }
	const bool full() { return rearSpace == upperBound || frontItem == 0; }
	int size() {return rearSpace - frontItem; }

	virtual string popRear(){
		if (empty()){
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return "";}
		else { return elements->at(--rearSpace); }
	}
	
	virtual string popFront(){
		if (empty()) {
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return ""; }
		else { return elements->at(frontItem++); }
	}

	virtual void pushFront(string newItem){
		elements->at(--frontItem) = newItem;
	}

	virtual void pushRear(string newItem){
		elements->at(rearSpace++) = newItem;
	}

	virtual string toString(){
		string out = "";
		for (int i = frontItem; i < rearSpace; i++) {
			out += elements->at(i) + " ";
		}
		return out; }
	

};

class PeekDeque: public StringDeque {
	friend class StringDeque;
	int peekIndex;
	
	public:

	PeekDeque():
		peekIndex(frontItem++),
		StringDeque(100) { }
		 

	virtual void moveFrontward(){
		peekIndex++;
	}

	virtual void moveRearward() {
		peekIndex--;
	}

	virtual string peek(){
		string a;
		a = elements->at(peekIndex);
		return a;
	}

	virtual string popRear(){
		if(empty()){ cout << "Attempt to pop from empty PeekDeque." << endl;
		return "";}
		else { return elements->at(--rearSpace); }
	}

	virtual string popFront(){
		if(empty()){ cout << "Attempt to pop from empty PeekDeque." << endl;
		return "";}
		else { return elements->at(frontItem++); }
	}

};



#endif
