//
//  TaskLoader.java
//

import java.util.*;
import java.io.* ;

public class TaskLoader {

  public static void main (String args[]) {
    
    try {
      if(args.length==0) {
	System.out.println("Please specify the JAR file name with the command");
	throw new Exception("JAR File name missing");
      }
      JARHandler jhandler = new JARHandler (args[0]) ;
          
      //  A JAR has been loaded by the classloader, but
      //  the JAR manifest may not have a registered Task-Thread attribute.  This means
      //  that we have no way of knowing which class we are supposed to run.
      //  If our classloader does not have a Task-Thread name, print a message,
      //  then print the list of resources found in the JAR for reference.
          
      if (jhandler.getTaskThreadName() == null) {
        System.out.println("TaskLoader: The Jar manifest did not have a Task-Thread attribute.\nPlease identify the Task-Thread and re-jar the data.  Here are the known Jar resources:\n") ;
            
        Enumeration enum = jhandler.getResourceEntries() ;
    
        while (enum.hasMoreElements()) {
          System.out.println((String) enum.nextElement()) ;
        }
            
      }
      else {
          
        // We have a Task-Thread, so let's try to load it.  Again, note that we assume
        // that the Task-Thread class is a Thread class.  This is a design decision for building
        // the grid.
            
        System.out.println("TaskLoader: Attempting to load " + jhandler.getTaskThreadName()) ;
        Thread task = (Thread) jhandler.loadClass(jhandler.getTaskThreadName()).newInstance();
        System.out.println("TaskLoader: Attempting to start Thread...") ;
        task.start();
      }
    }
    catch (ClassNotFoundException e) {
      System.out.println("TaskLoader: Could not find class:\n" + e.toString() + "\n" + e.getMessage()) ;
    }
    catch (Exception e) {
      System.out.println("TaskLoader: " + e.toString() + "\n" + e.getMessage()) ;
    }
                
  }  // Main.
    
}


