/*
 * Decompiled with CFR 0.152.
 */
package calltree;

import calltree.PlantUML;
import java.util.ArrayList;

public class Node {
    String object;
    String method;
    int startEvent;
    int endEvent;
    boolean current;
    String callerObject;
    String callerMethod;
    Node parent;
    ArrayList<Node> children = new ArrayList();
    PlantUML pl;

    Node() {
    }

    Node(String o, String m, int s, int e, boolean c, String co, String cm, PlantUML p) {
        this.object = o;
        this.method = m;
        this.startEvent = s;
        this.endEvent = e;
        this.current = c;
        this.callerObject = co;
        this.callerMethod = cm;
        this.pl = p;
    }

    void setCaller(String co, String cm) {
        this.callerObject = co;
        this.callerMethod = cm;
    }

    String getCallerObject() {
        return this.callerObject;
    }

    String getCallerMethod() {
        return this.callerMethod;
    }

    void printNode() {
        System.out.print(String.valueOf(this.object) + "," + this.method + "," + this.startEvent + "-" + this.endEvent + "," + this.callerObject + "," + this.callerMethod);
        System.out.println();
    }

    String getObject() {
        return this.object;
    }

    void setObject(String o) {
        this.object = o;
    }

    String getMethod() {
        return this.method;
    }

    void setMethod(String m) {
        this.method = m;
    }

    int getStartEvent() {
        return this.startEvent;
    }

    void setStartEvent(int s) {
        this.startEvent = s;
    }

    int getEndEvent() {
        return this.endEvent;
    }

    void setEndEvent(int e) {
        this.endEvent = e;
    }

    void addChild(Node c) {
        this.children.add(c);
        c.setParent(this);
    }

    void setParent(Node p) {
        this.parent = p;
    }

    Node getParent() {
        return this.parent;
    }

    boolean getCurrent() {
        return this.current;
    }

    void setCurrent(boolean c) {
        this.current = c;
    }

    void insert(Node n) {
        if (this.current) {
            this.current = false;
            this.children.add(n);
        } else {
            for (Node c : this.children) {
                c.insert(n);
            }
        }
    }

    void resetCurrent(int ee) {
        if (this.current) {
            this.endEvent = ee;
            this.current = false;
            return;
        }
        this.current = true;
        for (Node c : this.children) {
            if (!c.getCurrent()) continue;
            c.setEndEvent(ee);
            c.setCurrent(false);
            return;
        }
        this.current = false;
        for (Node c : this.children) {
            c.resetCurrent(ee);
        }
    }

    void printTree() {
        System.out.println(String.valueOf(this.object) + "," + this.method + "," + this.startEvent + "-" + this.endEvent + "," + this.current + "," + this.callerObject + "," + this.callerMethod);
        for (Node c : this.children) {
            c.printTree();
        }
    }

    void dfs(String color) {
        this.pl.tm.put(this.startEvent, "\"" + this.callerObject + "\"" + " -> " + "\"" + this.object + "\"" + " : " + this.method + "\n" + "activate " + "\"" + this.object + "\"" + " " + color);
        this.pl.tm.put(this.endEvent, "\"" + this.callerObject + "\"" + " <-- " + "\"" + this.object + "\"" + "\n" + "deactivate " + "\"" + this.object + "\"");
        for (Node c : this.children) {
            c.dfs(color);
        }
    }

    void exportToQSDE() {
    }
}

