/*
 * Decompiled with CFR 0.152.
 */
package calltree;

import calltree.CNode;
import calltree.Node;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class PlantUML {
    TreeMap<Integer, String> tm = new TreeMap();
    TreeMap<Integer, String> tmc = new TreeMap();
    TreeMap<String, ArrayList<CNode>> rmc = new TreeMap();
    ArrayList<String> loops = new ArrayList();
    static String outFile1 = "sequence.txt";
    static String outFile2 = "compact.txt";
    static FileWriter out1 = null;
    static FileWriter out2 = null;
    StringBuffer sb = new StringBuffer();
    StringBuffer csb = new StringBuffer();

    public void export(LinkedHashMap<String, Node> tct) {
        String[] color = new String[]{"#E9967A", "#9ACD32", "#DAA520", "#FFA500", "#228B22", "#66CDAA", "#7FFFD4", "#7FFFD4", "#00BFFF", "#8A2BE2", "#6A5ACD", "#BA55D3", "#DDA0DD", "#DB7093", "#F5DEB3", "#D2691E", "#CD853F", "#BC8F8F", "#708090", "#B0C4DE", "#C0C0C0", "#FFFACD"};
        int i = 0;
        Set<String> threads = tct.keySet();
        for (String t : threads) {
            Node n = tct.get(t);
            n.dfs(color[i]);
            ++i;
        }
    }

    public void print() {
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        FileOutputStream png = null;
        try {
            png = new FileOutputStream(String.valueOf(path.toFile().getPath()) + File.separator + "sequence.png");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.sb = new StringBuffer();
        this.sb.append("@startuml\n");
        this.sb.append("hide footbox\n");
        Set<Integer> eIds = this.tm.keySet();
        for (Integer e : eIds) {
            this.sb.append(String.valueOf(this.tm.get(e)) + "\n");
        }
        this.sb.append("@enduml\n");
        String source = this.sb.toString();
        SourceStringReader reader = new SourceStringReader(source);
        try {
            reader.generateImage((OutputStream)png);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void exportC(LinkedHashMap<String, CNode> tcct) {
        String[] color = new String[]{"#77CCFF", "#00AAAA", "#7F00FF", "#22FF22", "#FF8000", "#FFA500", "#E9967A", "#9ACD32", "#DAA520", "#228B22", "#66CDAA", "#7FFFD4", "#7FFFD4", "#00BFFF", "#8A2BE2", "#6A5ACD", "#BA55D3", "#DDA0DD", "#DB7093", "#F5DEB3", "#D2691E", "#CD853F", "#BC8F8F", "#708090", "#B0C4DE", "#C0C0C0", "#FFFACD"};
        int i = 0;
        Set<String> threads = tcct.keySet();
        for (String t : threads) {
            CNode n = tcct.get(t);
            n.dfsC(color[i]);
            ++i;
        }
        this.printC();
    }

    public void printC() {
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        System.out.println("Resource Location: " + path);
        FileOutputStream png = null;
        try {
            png = new FileOutputStream(String.valueOf(path.toFile().getPath()) + File.separator + "compact.png");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.csb = new StringBuffer();
        this.csb.append("@startuml\n");
        this.csb.append("hide footbox\n");
        this.csb.append("skinparam sequenceParticipantBackgroundColor #FFFFBB\n");
        this.csb.append("skinparam sequenceParticipantBorderColor #101010\n");
        this.csb.append("skinparam sequenceArrowColor #404040\n");
        this.csb.append("skinparam sequenceLifeLineBorderColor #808080\n");
        StringBuffer concurrentLabels = new StringBuffer();
        StringBuffer eventsBuffer = new StringBuffer();
        int numLoops = 0;
        new HashMap();
        Set<Integer> eventIds = this.tmc.keySet();
        for (Integer e : eventIds) {
            if (this.tmc.get(e).contains("\"SYSTEM\" -> \"SYSTEM\" : SYSTEM") || this.tmc.get(e).contains("\"SYSTEM\" <-- \"SYSTEM\"") || this.tmc.get(e).contains("activate \"SYSTEM\"")) continue;
            if (this.tmc.get(e).startsWith("loop")) {
                String[] tokens = this.tmc.get(e).split(" ");
                String regex = tokens[1];
                if (numLoops == 0) {
                    concurrentLabels.append(regex);
                } else {
                    concurrentLabels.append(" " + regex);
                }
                ++numLoops;
                continue;
            }
            if (this.tmc.get(e).startsWith("end")) {
                if (--numLoops != 0) continue;
                this.printInteractions(concurrentLabels.toString(), eventsBuffer.toString());
                concurrentLabels = new StringBuffer();
                eventsBuffer = new StringBuffer();
                continue;
            }
            if (numLoops > 0) {
                eventsBuffer.append(String.valueOf(this.tmc.get(e)) + "\n");
                continue;
            }
            this.csb.append(String.valueOf(this.tmc.get(e)) + "\n");
        }
        this.csb.append("@enduml\n");
        String source = this.csb.toString();
        SourceStringReader reader = new SourceStringReader(source);
        try {
            reader.generateImage((OutputStream)png);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void printInteractions(String cl, String eb) {
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        StringTokenizer st = new StringTokenizer(eb, "\n");
        while (st.hasMoreTokens()) {
            HashSet<Object> objects;
            String line = st.nextToken();
            if (!line.endsWith("     ")) continue;
            String[] tokens = line.split(" ");
            String caller = tokens[0];
            String object = tokens[2];
            if (map.containsKey(caller)) {
                objects = map.get(caller);
                objects.add(object);
                map.put(caller, objects);
                continue;
            }
            objects = new HashSet();
            objects.add(object);
            map.put(caller, objects);
        }
        cl = this.checkDisjoint(map) ? cl.replace(" ", " \u2297 ") : (this.checkInteference(cl) ? cl.replace(" ", " \u22c8  ") : cl.replace(" ", " \u2295  "));
        this.csb.append("\nloop " + cl + "\n");
        this.csb.append(String.valueOf(eb) + "\n");
        this.csb.append("end\n\n");
    }

    public boolean checkDisjoint(HashMap<String, HashSet<String>> map) {
        Set<String> callers = map.keySet();
        int indvSize = 0;
        int totalSize = 0;
        HashSet<String> mt = new HashSet<String>();
        for (String c : callers) {
            HashSet<String> t = map.get(c);
            indvSize += t.size();
            mt.addAll(t);
        }
        totalSize = mt.size();
        return totalSize == indvSize;
    }

    public boolean checkInteference(String cl) {
        String[] labels = cl.split(" ");
        int i = 0;
        while (i < labels.length) {
            ArrayList<CNode> rmi = this.rmc.get(labels[i]);
            int j = 0;
            while (j < labels.length) {
                if (i != j) {
                    ArrayList<CNode> rmj = this.rmc.get(labels[j]);
                    int m = 0;
                    while (m < rmi.size()) {
                        int sei = rmi.get(m).getStartEvent();
                        int eei = rmi.get(m).getEndEvent();
                        String oi = rmi.get(m).getObject();
                        int n = 0;
                        while (n < rmj.size()) {
                            int sej = rmj.get(n).getStartEvent();
                            rmj.get(n).getEndEvent();
                            String oj = rmj.get(n).getObject();
                            if (sei < sej && sej < eei && oi.equals(oj)) {
                                return true;
                            }
                            ++n;
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void printRMC() {
        Set<String> regex = this.rmc.keySet();
        for (String r : regex) {
            System.out.println(String.valueOf(r) + " --------> ");
            ArrayList<CNode> rmnodes = this.rmc.get(r);
            int i = 0;
            while (i < rmnodes.size()) {
                rmnodes.get(i).printNode();
                ++i;
            }
        }
    }

    public void printTMC() {
        Set<Integer> eventIds = this.tmc.keySet();
        for (Integer e : eventIds) {
            System.out.println(this.tmc.get(e));
        }
    }

    public static void drawSequenceDiagram() {
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        File seqDiagFile = new File(String.valueOf(path.toFile().getPath()) + File.separator + "sequence.txt");
        String s = null;
        String command = "java -jar plugins" + File.separator + "plantuml.jar " + "-o /home/icts/Downloads/ " + "\"" + seqDiagFile.getPath() + "\"" + " -encoding=utf8";
        System.out.println(command);
        try {
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdout.readLine()) != null) {
                System.out.println(s);
            }
            while ((s = stderr.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void drawCompactSequenceDiagram() {
        String s = null;
        String command = "java -jar plantuml.jar compact.txt -encoding=utf8";
        try {
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdout.readLine()) != null) {
                System.out.println(s);
            }
            while ((s = stderr.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

