/*
 * Decompiled with CFR 0.152.
 */
package regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.StringTokenizer;
import regex.Edge;
import regex.Vertex;

public class Dijkstra {
    public static void computePaths(Vertex source) {
        source.minDistance = 0.0;
        PriorityQueue<Vertex> vertexQueue = new PriorityQueue<Vertex>();
        vertexQueue.add(source);
        while (!vertexQueue.isEmpty()) {
            Vertex u = (Vertex)vertexQueue.poll();
            Edge[] edgeArray = u.adjacencies;
            int n = u.adjacencies.length;
            int n2 = 0;
            while (n2 < n) {
                Edge e = edgeArray[n2];
                try {
                    Vertex v = e.target;
                    double weight = e.weight;
                    double distanceThroughU = u.minDistance + weight;
                    if (distanceThroughU < v.minDistance) {
                        vertexQueue.remove(v);
                        v.minDistance = distanceThroughU;
                        v.previous = u;
                        vertexQueue.add(v);
                    }
                }
                catch (NullPointerException nullPointerException) {}
                ++n2;
            }
        }
    }

    public static List<Vertex> getShortestPathTo(Vertex target) {
        ArrayList<Vertex> path = new ArrayList<Vertex>();
        Vertex vertex = target;
        while (vertex != null) {
            path.add(vertex);
            vertex = vertex.previous;
        }
        Collections.reverse(path);
        return path;
    }

    public static String createGraph(String graph, int len) {
        Vertex[] v = new Vertex[len + 1];
        int i = 0;
        while (i <= len) {
            v[i] = new Vertex(Integer.toString(i));
            v[i].adjacencies = new Edge[len - i];
            ++i;
        }
        i = 0;
        while (i < len) {
            v[i].adjacencies[0] = new Edge(v[i + 1], 1.0);
            ++i;
        }
        StringTokenizer stg = new StringTokenizer(graph, "\n");
        while (stg.hasMoreTokens()) {
            String strLine = stg.nextToken();
            StringTokenizer st = new StringTokenizer(strLine, "->");
            String token = st.nextToken();
            int src = Integer.parseInt(token);
            boolean flag = false;
            int j = 1;
            do {
                if ((token = st.nextToken()).equals("$")) {
                    flag = true;
                    continue;
                }
                int dest = Integer.parseInt(token);
                if (dest == src + 1) continue;
                v[src].adjacencies[j] = new Edge(v[dest], 1.0);
                ++j;
            } while (!flag);
        }
        Dijkstra.computePaths(v[0]);
        List<Vertex> path = Dijkstra.getShortestPathTo(v[len]);
        return path.toString();
    }
}

