/*
 * Decompiled with CFR 0.152.
 */
package calltree;

import calltree.Node;
import calltree.PlantUML;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import regex.CallRepeat;
import regex.MinimalRegex;
import regex.TandemRepeat;
import utilities.Util;

public class CNode
extends Node {
    boolean isCompacted;
    String label;
    String encoding;
    LinkedHashMap<String, Character> map = new LinkedHashMap();
    LinkedHashMap<Character, String> rMap = new LinkedHashMap();
    ArrayList<CNode> removedChildren = new ArrayList();

    CNode() {
    }

    CNode(String o, String m, int s, int e, boolean c, String co, String cm, PlantUML p) {
        this.object = o;
        this.method = m;
        this.startEvent = s;
        this.endEvent = e;
        this.current = c;
        this.callerObject = co;
        this.callerMethod = cm;
        this.isCompacted = false;
        this.label = null;
        this.encoding = null;
        this.pl = p;
    }

    CNode(String o, String m, int s, int e, boolean c, String co, String cm, boolean isComp, PlantUML p) {
        this.object = o;
        this.method = m;
        this.startEvent = s;
        this.endEvent = e;
        this.current = c;
        this.callerObject = co;
        this.callerMethod = cm;
        this.isCompacted = isComp;
        this.label = null;
        this.encoding = null;
        this.pl = p;
    }

    @Override
    String getCallerObject() {
        return this.callerObject;
    }

    @Override
    String getCallerMethod() {
        return this.callerMethod;
    }

    @Override
    void printNode() {
        System.out.print(String.valueOf(this.object) + "," + this.method + "," + this.startEvent + "-" + this.endEvent + "," + this.isCompacted);
        System.out.println();
    }

    void setCompact(boolean isComp) {
        this.isCompacted = isComp;
    }

    boolean getCompact() {
        return this.isCompacted;
    }

    void setEncoding(String e) {
        this.encoding = e;
    }

    String getEncoding() {
        return this.encoding;
    }

    void compact(PlantUML p) {
        String sequence = "";
        for (CNode c : this.children) {
            c.compact(p);
            String mtd = Util.stripColon(c.getMethod());
            String call = new String(String.valueOf(c.getObject()) + "." + mtd);
            sequence = new String(String.valueOf(sequence) + this.updateMap(call));
        }
        MinimalRegex mr = new MinimalRegex();
        TandemRepeat[] labels = mr.findMinimalRegex(sequence);
        this.reverseMap();
        CallRepeat[] callLabels = this.replaceTRwithOM(labels);
        this.replaceChildren(callLabels, p);
    }

    char updateMap(String call) {
        if (!this.map.containsKey(call)) {
            this.map.put(call, Character.valueOf(Util.getNextSymbol()));
        }
        return this.map.get(call).charValue();
    }

    void reverseMap() {
        for (Map.Entry<String, Character> entry : this.map.entrySet()) {
            String key = entry.getKey();
            char value = entry.getValue().charValue();
            this.rMap.put(Character.valueOf(value), key);
        }
    }

    CallRepeat[] replaceTRwithOM(TandemRepeat[] labels) {
        CallRepeat[] cr = new CallRepeat[labels.length];
        int i = 0;
        while (i < labels.length) {
            StringBuffer cSeq = new StringBuffer();
            TandemRepeat tr = labels[i];
            if (tr.getAlpha().length() > 1) {
                cSeq.append("(");
                int j = 0;
                while (j < tr.getAlpha().length()) {
                    String objmtd = this.rMap.get(Character.valueOf(tr.getAlpha().charAt(j)));
                    cSeq.append(objmtd);
                    cSeq.append(";");
                    ++j;
                }
                cSeq.append(")");
                cr[i] = new CallRepeat(tr.getStartPos(), cSeq.toString(), tr.getAlpha().length(), tr.getRepeats());
            } else {
                String objmtd = this.rMap.get(Character.valueOf(tr.getAlpha().charAt(0)));
                cSeq.append(objmtd);
                cr[i] = new CallRepeat(tr.getStartPos(), cSeq.toString(), 1, tr.getRepeats());
            }
            ++i;
        }
        return cr;
    }

    void replaceChildren(CallRepeat[] cr, PlantUML p) {
        int i = cr.length - 1;
        while (i >= 0) {
            int pos = cr[i].getStartPos();
            cr[i].getObjMtd();
            int omlen = cr[i].getOMLen();
            int repeats = cr[i].getRepeats();
            if (omlen * repeats != 1) {
                CharSequence cm;
                CharSequence co;
                CharSequence m;
                CharSequence o;
                CNode c;
                if (omlen == 1 && repeats > 1) {
                    c = (CNode)this.children.get(pos);
                    o = c.getObject();
                    m = String.valueOf(c.getMethod()) + "^" + repeats;
                    int se = c.getStartEvent();
                    co = c.getCallerObject();
                    cm = c.getCallerMethod();
                    c = (CNode)this.children.get(pos + repeats - 1);
                    int ee = c.getEndEvent();
                    CNode cn = new CNode((String)o, (String)m, se, ee, false, (String)co, (String)cm, true, p);
                    int j = pos + repeats - 1;
                    while (j >= pos) {
                        CNode rm = (CNode)this.children.remove(j);
                        this.removedChildren.add(0, rm);
                        --j;
                    }
                    p.rmc.put(((String)m).toString(), this.removedChildren);
                    this.children.add(pos, cn);
                } else {
                    c = (CNode)this.children.get(pos);
                    o = new StringBuffer();
                    m = new StringBuffer();
                    StringBuffer m2 = new StringBuffer();
                    co = new StringBuffer();
                    cm = new StringBuffer();
                    int se = -1;
                    int ee = -1;
                    ((StringBuffer)m).append("(");
                    m2.append("(");
                    int j = pos;
                    while (j < pos + omlen) {
                        c = (CNode)this.children.get(j);
                        ((StringBuffer)o).append(String.valueOf(c.getObject()) + ";");
                        ((StringBuffer)m).append(String.valueOf(c.getObject()) + "." + c.getMethod() + "." + c.getStartEvent() + "." + c.getEndEvent() + ";");
                        m2.append(String.valueOf(c.getMethod()) + ";");
                        if (j == pos) {
                            se = c.getStartEvent();
                            ((StringBuffer)co).append(c.getCallerObject());
                            ((StringBuffer)cm).append(c.getCallerMethod());
                        }
                        ++j;
                    }
                    c = (CNode)this.children.get(pos + (omlen * repeats - 1));
                    ee = c.getEndEvent();
                    ((StringBuffer)m).append(")^");
                    ((StringBuffer)m).append(repeats);
                    m2.append(")^");
                    m2.append(repeats);
                    CNode cn = new CNode(((StringBuffer)o).toString(), ((StringBuffer)m).toString(), se, ee, false, ((StringBuffer)co).toString(), ((StringBuffer)cm).toString(), true, p);
                    int j2 = pos + (omlen * repeats - 1);
                    while (j2 >= pos) {
                        CNode rm = (CNode)this.children.remove(j2);
                        this.removedChildren.add(0, rm);
                        --j2;
                    }
                    p.rmc.put(m2.toString(), this.removedChildren);
                    this.children.add(pos, cn);
                }
            }
            --i;
        }
    }

    void dfsC(String color) {
        if (this.method.contains("^")) {
            StringTokenizer ste;
            StringTokenizer st;
            StringBuffer regex;
            String tmethod;
            int times;
            int pos;
            String[] objects = this.object.split(";");
            if (Util.countDistinctObjects(objects) == 1) {
                pos = this.method.indexOf(94);
                times = Integer.parseInt(this.method.substring(pos + 1));
                tmethod = null;
                if (this.method.startsWith("(")) {
                    tmethod = this.method.substring(1, pos - 1);
                    regex = new StringBuffer("(");
                    st = new StringTokenizer(tmethod, ";");
                    while (st.hasMoreTokens()) {
                        ste = new StringTokenizer(st.nextToken(), ".");
                        ste.nextToken();
                        String mtd = ste.nextToken();
                        int sev = Integer.parseInt(ste.nextToken());
                        int eev = Integer.parseInt(ste.nextToken());
                        regex.append(String.valueOf(mtd) + ";");
                        this.pl.tmc.put(sev, "\"" + this.callerObject + "\"" + " -> " + "\"" + objects[0] + "\"" + " : " + mtd + "     " + " \n" + "activate " + "\"" + objects[0] + "\"" + " " + color);
                        this.pl.tmc.put(eev, "\"" + this.callerObject + "\"" + " <-- " + "\"" + objects[0] + "\"" + "     " + " \n" + "deactivate " + "\"" + objects[0] + "\"");
                    }
                    regex.append(")^" + times);
                    this.pl.tmc.put(this.startEvent - 1, "loop " + regex);
                    this.pl.tmc.put(this.endEvent + 1, "end");
                } else {
                    tmethod = this.method.substring(0, pos);
                    this.pl.tmc.put(this.startEvent - 1, "loop " + this.method);
                    this.pl.tmc.put(this.startEvent, "\"" + this.callerObject + "\"" + " -> " + "\"" + objects[0] + "\"" + " : " + tmethod + "     " + " \n" + "activate " + "\"" + objects[0] + "\"" + " " + color);
                    this.pl.tmc.put(this.endEvent, "\"" + this.callerObject + "\"" + " <-- " + "\"" + objects[0] + "\"" + "     " + " \n" + "deactivate " + "\"" + objects[0] + "\"");
                    this.pl.tmc.put(this.endEvent + 1, "end");
                }
            } else {
                pos = this.method.indexOf(41);
                times = Integer.parseInt(this.method.substring(pos + 2));
                tmethod = this.method.substring(1, pos);
                regex = new StringBuffer("(");
                st = new StringTokenizer(tmethod, ";");
                while (st.hasMoreTokens()) {
                    ste = new StringTokenizer(st.nextToken(), ".");
                    String obj = ste.nextToken();
                    String mtd = ste.nextToken();
                    int sev = Integer.parseInt(ste.nextToken());
                    int eev = Integer.parseInt(ste.nextToken());
                    regex.append(String.valueOf(mtd) + ";");
                    this.pl.tmc.put(sev, "\"" + this.callerObject + "\"" + " -> " + "\"" + obj + "\"" + " : " + mtd + "     " + " \n" + "activate " + "\"" + obj + "\"" + " " + color);
                    this.pl.tmc.put(eev, "\"" + this.callerObject + "\"" + " <-- " + "\"" + obj + "\"" + "     " + " \n" + "deactivate " + "\"" + obj + "\"");
                }
                regex.append(")^" + times);
                this.pl.tmc.put(this.startEvent - 1, "loop " + regex);
                this.pl.tmc.put(this.endEvent + 1, "end");
            }
        } else {
            this.pl.tmc.put(this.startEvent, "\"" + this.callerObject + "\"" + " -> " + "\"" + this.object + "\"" + " : " + this.method + " \n" + "activate " + "\"" + this.object + "\"" + " " + color);
            this.pl.tmc.put(this.endEvent, "\"" + this.callerObject + "\"" + " <-- " + "\"" + this.object + "\"" + " \n" + "deactivate " + "\"" + this.object + "\"");
        }
        for (CNode c : this.children) {
            c.dfsC(color);
        }
    }

    void printMap() {
        for (Map.Entry<String, Character> entry : this.map.entrySet()) {
            String key = entry.getKey();
            char value = entry.getValue().charValue();
            System.out.println(String.valueOf(key) + " -> " + value);
        }
    }

    void printRMap() {
        for (Map.Entry<Character, String> entry : this.rMap.entrySet()) {
            char key = entry.getKey().charValue();
            String value = entry.getValue();
            System.out.println(String.valueOf(key) + " -> " + value);
        }
    }

    @Override
    void printTree() {
        String status = null;
        status = this.isCompacted ? "compacted" : "ordinary";
        System.out.println(String.valueOf(this.object) + "," + this.method + "," + this.startEvent + "-" + this.endEvent + "," + this.current + "," + this.callerObject + "," + this.callerMethod + "," + status);
        for (Node c : this.children) {
            c.printTree();
        }
    }

    void alterTree(TreeMap<String, String> instances) {
        String cObj = this.callerObject.contains(":") ? this.callerObject.substring(0, this.callerObject.indexOf(58)) : this.callerObject;
        String tObj = this.object.contains(":") ? this.object.substring(0, this.object.indexOf(58)) : this.object;
        if (instances.containsKey(cObj)) {
            this.callerMethod = String.valueOf(this.callerObject) + "-" + this.callerMethod;
            this.callerObject = instances.get(cObj);
        }
        if (instances.containsKey(tObj)) {
            this.method = String.valueOf(this.object) + "-" + this.method;
            this.object = instances.get(tObj);
        }
        System.out.println(String.valueOf(this.callerObject) + "," + this.callerMethod + "," + this.object + "," + this.method);
        for (CNode c : this.children) {
            c.alterTree(instances);
        }
    }

    @Override
    void exportToQSDE() {
    }

    void label() {
    }

    void determineSpan() {
    }
}

