/*
 * Decompiled with CFR 0.152.
 */
package regex;

import java.io.FileWriter;
import java.util.StringTokenizer;
import regex.Dijkstra;
import regex.TandemRepeat;

public class MinimalRegex {
    static final int ALLREPEATS = 1;
    static String sequence;
    static int[] pi;
    static String filename;
    static String filename2;
    static FileWriter tr;
    static String path;
    static StringBuffer graph;
    static StringBuffer tandemrepeats;

    static {
        pi = new int[500];
        filename = "graph.txt";
        filename2 = "tandemrepeats.txt";
        graph = new StringBuffer();
        tandemrepeats = new StringBuffer();
    }

    public TandemRepeat[] findMinimalRegex(String arg) {
        try {
            sequence = new String(arg);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Usage: java MinimalRegex <string-pattern>");
            return null;
        }
        int len = sequence.length();
        this.createAdjacencyList(len);
        int i = 1;
        while (i <= len) {
            this.findTandemRepeatsOnPrefix(sequence.substring(len - i), len - i);
            ++i;
        }
        Dijkstra dij = new Dijkstra();
        path = Dijkstra.createGraph(graph.toString(), len);
        TandemRepeat[] labels = this.findMinRE(path.substring(1, path.length() - 1));
        tandemrepeats = new StringBuffer();
        graph = new StringBuffer();
        return labels;
    }

    /*
     * Unable to fully structure code
     */
    void findTandemRepeatsOnPrefix(String suffixSequence, int index) {
        P = new StringBuffer(suffixSequence);
        patternLen = 0;
        repeatCount = true;
        suffixLen = P.length();
        MinimalRegex.pi[0] = 0;
        k = 0;
        q = 1;
        ** GOTO lbl16
        {
            k = MinimalRegex.pi[k - 1];
            do {
                if (k > 0 && P.toString().charAt(k) != P.toString().charAt(q)) continue block0;
                if (P.toString().charAt(k) == P.toString().charAt(q)) {
                    // empty if block
                }
                MinimalRegex.pi[q] = ++k;
                ++q;
lbl16:
                // 2 sources

            } while (q < suffixLen);
        }
        patternLen = this.findTandemRepeats(index, suffixLen);
    }

    int findPrimitiveTandemRepeat(int suffixLen) {
        int patternLen = 0;
        int q = 0;
        while (q < suffixLen / 2) {
            if (pi[q] != 0) break;
            ++patternLen;
            ++q;
        }
        while (q < suffixLen / 2) {
            if (pi[q + 1] < pi[q]) break;
            if (pi[q + 1] == pi[q]) {
                ++patternLen;
                ++q;
                continue;
            }
            if (pi[q] != pi[q - 1] + 1) break;
            ++q;
        }
        return patternLen;
    }

    int findTandemRepeats(int index, int suffixLen) {
        int patternLen = 0;
        int repeatCount = 1;
        int q = 0;
        while (q < suffixLen / 2) {
            if (pi[2 * q + 1] == q + 1) {
                patternLen = q + 1;
                repeatCount = this.findRepeatCount(patternLen, suffixLen);
                this.addTandemRepeat(index, patternLen, repeatCount);
                this.addAdjacencyList(index, patternLen, repeatCount);
                ++q;
                continue;
            }
            ++q;
        }
        return patternLen;
    }

    /*
     * Unable to fully structure code
     */
    int findRepeatCount(int patternLen, int suffixLen) {
        repeatCount = 1;
        q = 2;
        if (suffixLen != 1) ** GOTO lbl8
        return repeatCount;
        while (MinimalRegex.pi[q * patternLen - 1] == (q - 1) * patternLen) {
            ++q;
            ++repeatCount;
lbl8:
            // 2 sources

            if (q * patternLen <= suffixLen) continue;
        }
        return repeatCount;
    }

    void createAdjacencyList(int index) {
        graph.append(String.valueOf(index) + "->$\n");
    }

    void addAdjacencyList(int index, int patternLen, int repeatCount) {
        if (patternLen == 0) {
            graph.append(String.valueOf(index) + "->" + (index + 1) + "->");
        } else if (repeatCount == 1) {
            graph.append(String.valueOf(index) + "->" + (index + 1) + "->");
        } else {
            graph.append(String.valueOf(index) + "->");
            int i = 2;
            while (i <= repeatCount) {
                graph.append(String.valueOf(index + patternLen * i) + "->");
                ++i;
            }
        }
        graph.append("$\n");
    }

    void addTandemRepeat(int index, int patternLen, int repeatCount) {
        int q = 2;
        while (q <= repeatCount) {
            tandemrepeats.append(String.valueOf(index) + "," + sequence.substring(index, index + patternLen) + "," + q + "\n");
            ++q;
        }
    }

    TandemRepeat[] findMinRE(String path) {
        int numTokens = 0;
        StringBuffer re = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, ", ");
        numTokens = st.countTokens();
        TandemRepeat[] labels = new TandemRepeat[numTokens - 1];
        int next = Integer.parseInt(st.nextToken());
        int i = 0;
        while (st.hasMoreTokens()) {
            int prev = next;
            next = Integer.parseInt(st.nextToken());
            if (next - prev > 1) {
                labels[i] = this.findSubRE(prev, next);
                re.append("(" + labels[i].getAlpha() + ")^" + labels[i].getRepeats() + " ");
                ++i;
                continue;
            }
            re.append(sequence.charAt(prev));
            labels[i] = new TandemRepeat(prev, sequence.substring(prev, prev + 1), 1);
            ++i;
        }
        return labels;
    }

    TandemRepeat findSubRE(int prev, int next) {
        String strLine = new String();
        StringTokenizer sttr = new StringTokenizer(tandemrepeats.toString(), "\n");
        while (sttr.hasMoreTokens()) {
            int numRepeats;
            String pattern;
            int patternLen;
            strLine = sttr.nextToken();
            StringTokenizer st = new StringTokenizer(strLine, ",");
            int index = Integer.parseInt(st.nextToken());
            if (index != prev || next != index + (patternLen = (pattern = st.nextToken()).length()) * (numRepeats = Integer.parseInt(st.nextToken()))) continue;
            new String("(" + pattern + ")^" + numRepeats + " ");
            TandemRepeat tr = new TandemRepeat(index, pattern, numRepeats);
            return tr;
        }
        return null;
    }

    public static void main(String[] args) {
        MinimalRegex m = new MinimalRegex();
        TandemRepeat[] tr = m.findMinimalRegex("bbebeebebebbebee");
        int i = 0;
        while (i < tr.length) {
            tr[i].printTandemRepeat();
            ++i;
        }
    }
}

