/*
 * Decompiled with CFR 0.152.
 */
package viewpart;

import calltree.CNode;
import calltree.CallTrees;
import calltree.CompactCallTrees;
import calltree.Node;
import calltree.PlantUML;
import events.ContextShiftEvent;
import events.Event;
import events.EventSequence;
import events.LineStepEvent;
import events.MethodCallEvent;
import events.MethodEnteredEvent;
import events.MethodExitEvent;
import events.MethodReturnedEvent;
import events.NewObjectEvent;
import events.SystemEndEvent;
import events.SystemStartEvent;
import events.ThreadEndEvent;
import events.ThreadStartEvent;
import events.TypeLoadEvent;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import utilities.Util;

public class SequenceDiagramCompaction
extends ViewPart {
    private IStatusLineManager statusLineManager;
    private Display display;
    private ScrolledComposite rootScrollComposite;
    private Composite mainComposite;
    private Label fileLabel;
    private Text fileText;
    private Button browseButton;
    private Button exportButton;
    Composite imageComposite;
    private Label imageLabel;
    private Image image;
    private Button hcChkBox;
    private Label mergeLabel;
    private Text mergeCountText;
    public boolean horizontal;
    public int mergeCount;

    public void createPartControl(Composite parent) {
        this.statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.display = parent.getDisplay();
        GridLayout layoutParent = new GridLayout();
        layoutParent.numColumns = 1;
        parent.setLayout((Layout)layoutParent);
        this.rootScrollComposite = new ScrolledComposite(parent, 768);
        this.rootScrollComposite.setLayout((Layout)new GridLayout(1, false));
        this.rootScrollComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rootScrollComposite.setExpandHorizontal(true);
        this.rootScrollComposite.setExpandVertical(true);
        this.mainComposite = new Composite((Composite)this.rootScrollComposite, 0);
        this.rootScrollComposite.setContent((Control)this.mainComposite);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite browseComposite = new Composite(this.mainComposite, 0);
        browseComposite.setLayout((Layout)new GridLayout(4, false));
        browseComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.exportButton = new Button(browseComposite, 8);
        this.exportButton.setText("Export");
        this.browseButton = new Button(browseComposite, 8);
        this.browseButton.setText("Browse");
        this.fileLabel = new Label(browseComposite, 4);
        this.fileLabel.setText("CSV File : ");
        this.fileText = new Text(browseComposite, 8);
        this.fileText.setBackground(Display.getCurrent().getSystemColor(15));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.fileText.setLayoutData((Object)gd);
        Composite hcComposite = new Composite(this.mainComposite, 0);
        hcComposite.setLayout((Layout)new GridLayout(4, false));
        hcComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.hcChkBox = new Button(hcComposite, 32);
        this.hcChkBox.setText("Horizontal Compaction");
        Label vertSeparator = new Label(hcComposite, 0);
        vertSeparator.setText("       |       ");
        this.mergeLabel = new Label(hcComposite, 4);
        this.mergeLabel.setText("Merge lifelines for object instances greater than: ");
        this.mergeCountText = new Text(hcComposite, 2052);
        GridData gd1 = new GridData();
        gd1.widthHint = 50;
        this.mergeCountText.setLayoutData((Object)gd1);
        this.imageComposite = new Composite(this.mainComposite, 0);
        this.imageComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageLabel = new Label(this.imageComposite, 0);
        this.rootScrollComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceDiagramCompaction.this.browseButtonAction(e);
            }
        });
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceDiagramCompaction.this.exportButtonAction(e);
            }
        });
        this.imageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SequenceDiagramCompaction.this.image != null && !SequenceDiagramCompaction.this.image.isDisposed()) {
                    System.out.println("Image disposed");
                    SequenceDiagramCompaction.this.image.dispose();
                }
            }
        });
    }

    private void browseButtonAction(SelectionEvent e) {
        this.horizontal = false;
        this.mergeCount = 1000;
        if (this.image != null && !this.image.isDisposed()) {
            System.out.println("Image disposedx");
            this.image.dispose();
        }
        this.statusLineManager.setMessage(null);
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent(), 4096));
        fd.setText("Open CSV File");
        String[] filterExtensions = new String[]{"*.csv"};
        fd.setFilterExtensions(filterExtensions);
        String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        this.fileText.setText(fileName);
        this.horizontal = this.hcChkBox.getSelection();
        if (this.horizontal) {
            String mergeCountString = this.mergeCountText.getText();
            if (mergeCountString.isEmpty()) {
                this.mergeCount = 1;
            } else {
                this.mergeCount = -1;
                try {
                    this.mergeCount = Integer.parseInt(mergeCountString);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Error", (String)("ERROR: '" + mergeCountString + "' is not an integer"));
                    this.mergeCountText.setFocus();
                }
                if (this.mergeCount == -1) {
                    return;
                }
            }
        } else {
            this.mergeCount = 1000;
        }
        System.out.println("-------- horizontal=" + this.horizontal + ", mergeCount=" + this.mergeCount);
        PlantUML p = new PlantUML();
        EventSequence events = new EventSequence();
        this.loadEvents(fileName, events);
        LinkedHashMap<String, Node> tct = CallTrees.construct(events, p);
        p.export(tct);
        LinkedHashMap<String, CNode> tcct = CompactCallTrees.construct(events, p);
        CompactCallTrees.alterObjects(this.mergeCount);
        CompactCallTrees.compact(p);
        p.exportC(tcct);
        try {
            IPath path = ResourcesPlugin.getPlugin().getStateLocation();
            File seqDiagFile = new File(String.valueOf(path.toFile().getPath()) + File.separator + "compact.png");
            this.image = new Image((Device)this.display, seqDiagFile.getPath());
            this.imageLabel.setImage(this.image);
        }
        catch (Exception ie) {
            MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Exception", (String)("An exception occured: " + ie.getMessage()));
        }
        this.statusLineManager.setMessage("Compact sequence diagram");
        this.imageComposite.pack();
        this.rootScrollComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.mergeCount = 100;
        this.horizontal = false;
    }

    private void exportButtonAction(SelectionEvent e) {
        if (this.image == null) {
            MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Warning", (String)"No image exists!");
            return;
        }
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent()), 8192);
        fd.setText("Export As");
        String[] filterExtensions = new String[]{"*.png", "*.bmp", "*.jpg"};
        fd.setFilterExtensions(filterExtensions);
        String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        int fileType = fd.getFilterIndex();
        int format = -1;
        switch (fileType) {
            case 0: {
                format = 5;
                break;
            }
            case 1: {
                format = 0;
                break;
            }
            case 2: {
                format = 4;
            }
        }
        try {
            ImageLoader imageLoader = new ImageLoader();
            ImageData[] imageDatas = new ImageData[]{this.image.getImageData()};
            imageLoader.data = imageDatas;
            imageLoader.save(fileName, format);
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Exception", (String)("An exception occured: " + ex.getMessage()));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadEvents(String csvFile, EventSequence events) {
        eventId = -1;
        lineNumber = -1;
        prevThread = "main";
        br = Util.openInFile(csvFile);
        sb = null;
        try lbl-1000:
        // 17 sources

        {
            block33: while ((strLine = Util.readLine(br, csvFile)) != null) {
                block39: {
                    sb = new StringBuffer(strLine);
                    i = 0;
                    while (true) {
                        if ((pos = sb.indexOf("\"", i)) == -1) {
                            strLine = sb.toString();
                            st = new StringTokenizer(strLine, ",");
                            thread = st.nextToken().trim();
                            if (!(thread.equals(prevThread) || prevThread.equals("SYSTEM") || thread.equals("SYSTEM"))) {
                                cs = new ContextShiftEvent(prevThread, -1, thread, -1, "Context Shift");
                                events.add(cs);
                                prevThread = thread;
                            }
                            eventId = Integer.parseInt(st.nextToken().trim());
                            slnField = st.nextToken().trim();
                            if (slnField.equals("SYSTEM")) break;
                            stsln = new StringTokenizer(slnField, ":");
                            source = stsln.nextToken();
                            lineNumber = Integer.parseInt(stsln.nextToken());
                            break block39;
                        }
                        sb.deleteCharAt(pos);
                        i = pos;
                    }
                    source = slnField;
                }
                var25_26 = eventType = st.nextToken().trim();
                tmp = -1;
                switch (var25_26.hashCode()) {
                    case -2014179535: {
                        if (!var25_26.equals("System Start")) break;
                        tmp = 1;
                        break;
                    }
                    case -1937040692: {
                        if (!var25_26.equals("Thread Start")) break;
                        tmp = 2;
                        break;
                    }
                    case -1830998516: {
                        if (!var25_26.equals("Type Load")) break;
                        tmp = 3;
                        break;
                    }
                    case -1783855812: {
                        if (!var25_26.equals("Field Read")) break;
                        tmp = 4;
                        break;
                    }
                    case -1660208278: {
                        if (!var25_26.equals("System End")) break;
                        tmp = 5;
                        break;
                    }
                    case -1325253681: {
                        if (!var25_26.equals("Variable Delete")) break;
                        tmp = 4;
                        break;
                    }
                    case -855681490: {
                        if (!var25_26.equals("Method Returned")) break;
                        tmp = 6;
                        break;
                    }
                    case -639820488: {
                        if (!var25_26.equals("Method Entered")) break;
                        tmp = 7;
                        break;
                    }
                    case -24818373: {
                        if (!var25_26.equals("Variable Write")) break;
                        tmp = 4;
                        break;
                    }
                    case 71211925: {
                        if (!var25_26.equals("Exception Throw")) break;
                        tmp = 4;
                        break;
                    }
                    case 148747128: {
                        if (!var25_26.equals("Line Step")) break;
                        tmp = 4;
                        break;
                    }
                    case 540057849: {
                        if (!var25_26.equals("Field Write")) break;
                        tmp = 4;
                        break;
                    }
                    case 681253437: {
                        if (!var25_26.equals("Method Call")) break;
                        tmp = 8;
                        break;
                    }
                    case 681335037: {
                        if (!var25_26.equals("Method Exit")) break;
                        tmp = 9;
                        break;
                    }
                    case 806908357: {
                        if (!var25_26.equals("Thread End")) break;
                        tmp = 10;
                        break;
                    }
                    case 1614353919: {
                        if (!var25_26.equals("New Object")) break;
                        tmp = 11;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        ss = new SystemStartEvent(thread, eventId, source, eventType);
                        events.add(ss);
                        ** break;
                    }
                    case 5: {
                        se = new SystemEndEvent(thread, eventId, source, eventType);
                        events.add(se);
                        ** break;
                    }
                    case 2: {
                        ts = new ThreadStartEvent(thread, eventId, source, eventType);
                        events.add(ts);
                        ** break;
                    }
                    case 10: {
                        te = new ThreadEndEvent(thread, eventId, source, eventType);
                        events.add(te);
                        ** break;
                    }
                    case 3: {
                        tlField = st.nextToken().trim();
                        stt = new StringTokenizer(tlField, "=");
                        stt.nextToken().trim();
                        classType = stt.nextToken().trim();
                        tl = new TypeLoadEvent(thread, eventId, source, eventType, classType);
                        events.add(tl);
                        ** break;
                    }
                    case 11: {
                        noField = st.nextToken().trim();
                        stn = new StringTokenizer(noField, "=");
                        stn.nextToken().trim();
                        newObject = stn.nextToken().trim();
                        no = new NewObjectEvent(thread, eventId, source, eventType, newObject);
                        events.add(no);
                        ** break;
                    }
                    case 8: {
                        cField = st.nextToken().trim();
                        if (cField.equals("caller=SYSTEM")) {
                            cField = "caller=SYSTEM#SYSTEM";
                        }
                        tField = st.nextToken().trim();
                        if (cField.contains("#") && tField.contains("#")) {
                            stc = null;
                            stc = new StringTokenizer(cField, "=#");
                            stc.nextToken().trim();
                            cObject = stc.nextToken();
                            cMethod = cObject.equals("SYSTEM") != false ? "SYSTEM" : stc.nextToken().trim();
                            sttg = null;
                            sttg = new StringTokenizer(tField, "=#");
                            sttg.nextToken().trim();
                            tObject = sttg.nextToken().trim();
                            tMethod = sttg.nextToken().trim();
                            mc = new MethodCallEvent(thread, eventId, source, lineNumber, eventType, cObject, cMethod, tObject, tMethod);
                            events.add(mc);
                            ** break;
                        }
                        if (cField.contains("#") && !tField.contains("#") || cField.contains("#") || !tField.contains("#")) continue block33;
                        cObject = "SYSTEM";
                        cMethod = "SYSTEM";
                        sttg = null;
                        sttg = new StringTokenizer(tField, "=#");
                        sttg.nextToken().trim();
                        tObject = sttg.nextToken().trim();
                        tMethod = sttg.nextToken().trim();
                        mc = new MethodCallEvent(thread, eventId, source, lineNumber, eventType, cObject, cMethod, tObject, tMethod);
                        events.add(mc);
                        ** break;
                    }
                    case 7: {
                        men = new MethodEnteredEvent(thread, eventId, source, lineNumber, eventType);
                        events.add(men);
                        ** break;
                    }
                    case 9: {
                        rField = st.nextToken().trim();
                        str = null;
                        if (!rField.contains("#")) ** break;
                        str = new StringTokenizer(rField, "=#");
                        str.nextToken().trim();
                        rObject = str.nextToken().trim();
                        rMethod = str.nextToken().trim();
                        if (!st.hasMoreTokens()) continue block33;
                        vField = st.nextToken().trim();
                        stv = new StringTokenizer(vField, "=");
                        stv.nextToken().trim();
                        rValue = stv.hasMoreTokens() != false ? stv.nextToken().trim() : null;
                        me = new MethodExitEvent(thread, eventId, source, lineNumber, eventType, rObject, rMethod, rValue);
                        events.add(me);
                        ** break;
                    }
                    case 6: {
                        mr = new MethodReturnedEvent(thread, eventId, source, lineNumber, eventType);
                        events.add(mr);
                        ** break;
                    }
                    default: {
                        def = new LineStepEvent(thread, eventId, source, lineNumber, eventType);
                        events.add(def);
                        continue block33;
                    }
                    case 4: 
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Exception", (String)("An exception occured while parsing: " + csvFile + "\n" + sb.toString()));
            return;
        }
        Util.closeInFile(br, csvFile);
    }

    public void printEvents(EventSequence events) {
        for (Event e : events) {
            e.printEvent();
        }
    }

    public void setFocus() {
    }
}

