package Scheduler;

import java.util.ArrayList;

public class Request {

	public Request(Process p, String id, boolean cmd, String type, String channel1) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;
		this.type = type;
		this.channel1 = channel1;			// one channel, no data
		this.channel2 = "";
	}
	
	public Request(Process p, String id, boolean cmd, String type, String channel1, Guard g) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;
		this.type = type;
		this.channel1 = channel1;			// one channel, no data
		this.channel2 = "";
		this.guard1 = g;
	}
	
	public Request(Process p, String id, boolean cmd, String type, String channel1, Object data1) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;
		this.type = type;
		this.channel1 = channel1;			// one channel, with data
		this.channel2 = "";
		this.data1 = data1;
	}

	//type can be await
	public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;                     // for mixed, it is the cmd of the first channel
		this.type = type;                   // could be two receives, or two sends, or mixed
		this.channel1 = channel1;			// but no data
		this.channel2 = channel2;
	}
	
	public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2, Object data1) {
			this.process = p;
			this.id = id;
			this.cmd = cmd;
			this.type = type;               // "mixed"  
			this.channel1 = channel1;		 
			this.channel2 = channel2;
			this.data1 = data1;            // only one data field for mixed
	}
	
	public Request(Process p, String id, String type, Guard g) {
		this.process = p;
		this.id = id;
		this.type = type;
		this.guard1 = g;
		this.channel1 = "";		 
		this.channel2 = "";
	}
	
	public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2, Guard g) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;          // cmd = false when there is a guard on channel1
		this.type = type;                
		this.channel1 = channel1;		 
		this.channel2 = channel2;
		this.guard1 = g;                  
   }
	
	public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2, Guard g1, Guard g2) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;          // cmd = false when there is a guard on channel1
		this.type = type;                
		this.channel1 = channel1;		 
		this.channel2 = channel2;
		this.guard1 = g1;   
		this.guard2 = g2;   
   }
		
		String id;       // e.g., Reader, Writer, or RWController
		boolean cmd;     // true = send, false = receive
		Process process; // e.g., Reader, Writer, or RWController
		String type;     // unary or binary or mixed
		String channel1; // channel name
		String channel2; // channel name or "" (for unary)
		Object data1;
		Guard guard1 = null;
		Guard guard2 = null;

		//Object data2 = null;
		//ArrayList<Object> list = null;   // for data-based request processing; not yet complete
	}

/*	
public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2, Object data1, Object data2) {
	this.process = p;
	this.id = id;
	this.cmd = cmd;                 // must be 'send', given data1 and data2
	this.type = type;
	this.channel1 = channel1;		// two channels with data
	this.channel2 = channel2;
	this.data1 = data1;
	this.data2 = data2;
}

public Request(Process p, String id, boolean cmd, String type, String channel1, ArrayList<Object> l) {
	this.process = p;
	this.id = id;
	this.cmd = cmd;
	this.type = type;
	this.channel1 = channel1;			// one channel, no data
	this.channel2 = "";
	this.list = l;
}
*/