package Scheduler;

import java.util.ArrayList;
import java.util.LinkedList;

import java.util.Random;

class Waiting {
	boolean cmd;
	String chan;
	int count;
	public Waiting (boolean cm, String ch, int c) {
		cmd = cm;
		chan = ch;
		count = c;
	}
}

public class Scheduler extends Thread {

	String scheduled;
	int count = 0;
	String waitlist = "";
	ArrayList<Waiting> wl = new ArrayList<Waiting>();
	Random ran = new Random();
	boolean debug;
	boolean matched = false;
	
	public Scheduler(Process[] arr, boolean debug) {
	   this.debug = debug;
	   for (int i=0; i<arr.length; i++) {
		   arr[i].scheduler = this;
		   (new Thread(arr[i])).start();
	   }
	}

	LinkedList<Request> l = new LinkedList<Request>();

	public void run() {
		while (true)
			schedule();
	}

	synchronized void enqueue(Request r) {
		l.addLast(r);
		boolean found = false;
		for (Waiting w: wl) {
			switch (r.type) {
			case ("unary"):
				if (w.cmd == r.cmd && w.chan.equals(r.channel1)) {
					w.count++;
					found = true;
					break;
				}
				break;
			case ("binary"):
				if (w.cmd == r.cmd && (w.chan.equals(r.channel1) || w.chan.equals(r.channel2))) {
					w.count++;
					found = true;
					break;
				}
				break;
			case("mixed"):
				if ((w.cmd == r.cmd && r.cmd && w.chan.equals(r.channel1)) || (w.cmd == r.cmd && !r.cmd && w.chan.equals(r.channel2)) ||
				    (w.cmd != r.cmd && r.cmd && w.chan.equals(r.channel2)) || (w.cmd != r.cmd && !r.cmd && w.chan.equals(r.channel1))) {
					w.count++;
					found = true;
					break;
				}
			}
		}
		if (!found)
			wl.add(new Waiting(r.cmd, r.channel1, 1));
		notifyAll();
	}
	
	void dequeue(Request r) {
		l.remove(r);
		for (Waiting w: wl) 
			if (w.cmd == r.cmd && w.chan.equals(r.channel1)) {
				w.count--;
			}
	}
	
	public synchronized int count(String cmd, String chan) {
		int sum = 0;
		for (Request r : l) {
			String c;
			if (r.cmd) 
				 c = "send";
			else c = "receive";
			if (r.type.equals("unary")) {
				if (c.equals(cmd) && r.channel1.equals(chan))  {
					 sum++;
				}
			}
			if (r.type.equals("binary")) {
				if (c.equals(cmd) && (r.channel1.equals(chan) || r.channel2.equals(chan)))  {
					 sum++;
				}
		    }
			// consider mixed also
		}
	    return sum;
	}
	
	boolean check_await() {
		boolean found = false;
		Request r2 = null;
		  for (Request r : l) {
			if (r.type.equals("await")) {
				String c;
				if (r.cmd) 
					 c = "send";
				else c = "receive";
				int c1 = count(c,r.channel1);
				int c2 = count(c,r.channel2);
				if (c1 > 0 || c2 > 0)  {
					r.process.wakeup(r);
					r2 = r;
					found = true;
					if (c1 > 0) 
						 r.process.chosen = r.channel1;
					else r.process.chosen = r.channel2;
					break;
				}
			}
		}
		if (found) 
			dequeue(r2);
		return found;
	}
	
	boolean check_await_guard() {
		boolean found = false;
		Request r2 = null;
		  for (Request r : l) {
			if (r.type.equals("await_guard")) {
				 if (r.guard1.test(null)) {
					 r.process.wakeup(r);
					 r2 = r;
					 found = true;
				 }
			}
		}
		if (found) 
			dequeue(r2);
		return found;
	}

	synchronized void schedule() {

		Request rem_r1 = null; // requests to be removed
		Request rem_r2 = null;
		
		if (debug) print_wait_list();
		
		matched = false;
		
		check_await();
		
		check_await_guard();
		
		for (Request r1 : l) {	
			
			if (r1.type.equals("await") || r1.type.equals("await_guard"))
				continue;
			
			for (Request r2 : l) {

				String r1_cmd, r2_cmd;
				
				if (r2.type.equals("await") || r2.type.equals("await_guard"))
					continue;
				
				if (r1 == r2)
					continue;
				
				if (r1.type.equals("unary") && r2.type.equals("unary")) {

					if (r1.cmd == r2.cmd)
						continue;

					if (r1.cmd) {
						r1_cmd = "send";
						r2_cmd = "receive";
					} else {
						r2_cmd = "send";
						r1_cmd = "receive";
					}

					if (r1.channel1.equals(r2.channel1)) {
						if (!r1.cmd && r1.guard1 != null || !r2.cmd && r2.guard1 != null) { // guarded receive
							if (!r1.cmd && r1.guard1.test(r2.data1) || !r2.cmd && r2.guard1.test(r1.data1)) {
								rem_r1 = r1; // must remove r1 and r2 outside for
								rem_r2 = r2;
								matched = true;
								unary_unary(r1, r2, r1_cmd, r2_cmd);
							}
						}
						else {	
						rem_r1 = r1; // must remove r1 and r2 outside for
						rem_r2 = r2;
						matched = true;
						unary_unary(r1, r2, r1_cmd, r2_cmd);
						}
					}
				}

				else if (r1.type.equals("unary") && r2.type.equals("mixed")) {
					// Note: first channel of "mixed" does a send
					if (r1.cmd)
						r1_cmd = "send";
					else
						r1_cmd = "receive";

					if (r1.cmd) // send
						if (!r1.channel1.equals(r2.channel2))
							continue;
						else { // send-receive pair found
							rem_r1 = r1; // must remove r1 and r2
							rem_r2 = r2;
							matched = true;
							unary_mixed(r1, r2, "send", "receive", r1.channel1);
						}
					else // r1 is a receive
					if (r1.channel1.equals(r2.channel1)) {
						rem_r1 = r1; // must remove r1 and r2 
						rem_r2 = r2;
						matched = true;
						unary_mixed(r1, r2, "receive", "send", r1.channel1);
					}
				}

				else if (r1.type.equals("unary") && r2.type.equals("binary")) {

					if (r1.cmd == r2.cmd)
						continue;

					if (r1.cmd) {
						r1_cmd = "send";
						r2_cmd = "receive";
					} else {
						r2_cmd = "send";
						r1_cmd = "receive";
					}

					if (r1.channel1.equals(r2.channel1) || r1.channel1.equals(r2.channel2)) {
						if (!r2.cmd)
							if (r1.channel1.equals(r2.channel1)) // guarded binary receive
								if (r2.guard1 != null)
									if (r2.guard1.test(r1.data1)) {
										rem_r1 = r1;
										rem_r2 = r2;
										matched = true;
										unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
									} 
								    else continue;
							    else {
							    	rem_r1 = r1;
							    	rem_r2 = r2;
							    	matched = true;
							    	unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
							    }	
						   else { // r1.channel1.equals(r2.channel2)
							   if (r2.guard2 != null)
									if (r2.guard2.test(r1.data1)) {
										rem_r1 = r1;
										rem_r2 = r2;
										matched = true;
										unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
									} 
								    else continue;
							    else {
							    	rem_r1 = r1;
							    	rem_r2 = r2;
							    	matched = true;
							    	unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
							    }	
						   }
						else {
							rem_r1 = r1;
							rem_r2 = r2;
							matched = true;
							unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
						}
					}
				}  

				else if (r1.type.equals("binary") && r2.type.equals("binary")) {

					if (r1.cmd == true) {
						r1_cmd = "send";
						r2_cmd = "receive";
					} else {
						r2_cmd = "send";
						r1_cmd = "receive";
					}

					if (r1.channel1.equals(r2.channel1) && r1.channel2.equals(r2.channel2)
							|| r1.channel1.equals(r2.channel2) && r2.channel1.equals(r1.channel2)) {
						int r = ran.nextInt(9999) % 2;
						rem_r1 = r1; // must remove r1 and r2 outside for
						rem_r2 = r2;
						matched = true;
						if (r == 0)
							binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel1);
						else
							binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel2);
					}

					// no need for random selection since there is only one
					// match

					else if (r1.channel1.equals(r2.channel1) || r1.channel1.equals(r2.channel2)) {
						rem_r1 = r1; // must remove r1 and r2 outside for
						rem_r2 = r2;
						matched = true;
						binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel1);
					}

					else if (r2.channel1.equals(r1.channel2) || r2.channel2.equals(r1.channel2)) {
						rem_r1 = r1; // must remove r1 and r2 outside for
						rem_r2 = r2;
						matched = true;
						binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel2);
					}
				}
				if (rem_r1 != null)
					break;
			}
			if (rem_r1 != null)
				break;
		}
		if (rem_r1 != null)
			dequeue(rem_r1); 
		if (rem_r2 != null)
			dequeue(rem_r2); 
		
		if (!matched || (l.size() < 2)) 
			try { wait(); } 
		    catch (InterruptedException e) {}
	}

	void unary_unary(Request r1, Request r2, String r1_cmd, String r2_cmd) {
		count++;

		if (debug)
			System.out.println("	Schedule " + count + " ==> " + r1_cmd + "-" + r1.channel1 + "  and  " + r2_cmd + "-"
				+ r2.channel1 + "\n");

		if (r1_cmd.equals("send") &&  r1.data1 != null)
			r2.data1 = r1.data1;
		else if (r2.data1 != null)
			r1.data1 = r2.data1;

		r1.process.wakeup(r1);
		r2.process.wakeup(r2);
		scheduled = r1.channel1;
		return;
	}

	void unary_binary(Request r1, Request r2, String r1_cmd, String r2_cmd, String chan) {
		// r1 is binary and r2 is unary
		count++;
		
		if (debug)
		System.out.println("	Schedule " + count + " ==> " + r2_cmd + "-" + r2.channel1 + "  and  " + (r1_cmd) + "-("
				+ r1.channel1 + "|" + r1.channel2 + ")\n");

		if (r1_cmd.equals("send"))
			r2.data1 = r1.data1;
		else // r1_cmd.equals("receive"
			r1.data1 = r2.data1;

		
		r1.process.chosen(chan);
		r1.process.wakeup(r1);
		r2.process.wakeup(r2);
		scheduled = chan;
	}

	void unary_mixed(Request r1, Request r2, String r1_cmd, String r2_cmd, String chan) {
		// r1 is unary and r2 is mixed
		count++;
		
		if (debug)
		System.out.println("	Schedule " + count + " ==> " + r1_cmd + "-" + r1.channel1 + "  and  " + "(" + "send:"
				+ r2.channel1 + "|" + "receive:" + r2.channel2 + ")");

		if (r1_cmd.equals("send"))
			r2.data1 = r1.data1;
		if (r1_cmd.equals("receive"))
			r1.data1 = r2.data1;

		r2.process.chosen(chan);
		r1.process.wakeup(r1);
		r2.process.wakeup(r2);
		scheduled = chan;
	}

	void binary_binary(Request r1, Request r2, String r1_cmd, String r2_cmd, String chan) {
		count++;
		
		if (debug)
		System.out.println("	Schedule " + count + " ==> " + (r1_cmd) + "-(" + r1.channel1 + "|" + r1.channel2
				+ ")  and  " + (r2_cmd) + "-(" + r2.channel1 + "|" + r2.channel2 + ")\n");
		r1.process.chosen(chan);
		r2.process.chosen(chan);
		r1.process.wakeup(r1);
		r2.process.wakeup(r2);
		scheduled = chan;
	}

	void print_wait_list() {
		waitlist = "";
		for (Request r : l) {
			String r_cmd;
			
			if (r.cmd)
				r_cmd = "send";
			else
				r_cmd = "receive";
			if (r.type.equals("await")) {
				waitlist = waitlist + ("await_" + r_cmd) + "-" + r.channel1 + "-" + r.channel2 + ";   ";
				continue;
			}
			if (r.type == "unary")
				waitlist = waitlist + (r_cmd) + "-" + r.channel1 + ";   ";
			else
			if (r.type == "mixed")
				waitlist = waitlist +  "(send:" + r.channel1 + "|" + "receive:" + r.channel2 + ");   ";
			else
				waitlist = waitlist + (r_cmd) + "-(" + r.channel1 + "|" + r.channel2 + ");   ";
			r = null;
		}

		System.out.println(waitlist + "\n");
	}

}
