

import java.util.LinkedList;

import java.util.Random;


 class Request {
	public Request(Process p, String id, boolean cmd, String type, String channel1, String channel2) {
		this.process = p;
		this.id = id;
		this.cmd = cmd;
		this.type = type;
		this.channel1 = channel1;
		this.channel2 = channel2;
	}

	String id;       // e.g., Reader, Writer, or RWController
	boolean cmd;     // true = send, false = receive
	Process process; // e.g., Reader, Writer, or RWController
	String type;     // unary or binary
	String channel1; // channel name
	String channel2; // channel name or "" (for unary)
}


 abstract class Process {

	public Scheduler scheduler;
	protected String id;
	protected Request my_req = null;
	Request some_req = null;

	public synchronized void pause() {
		while (some_req == null) {
			try {
				wait();
			} catch (InterruptedException e) {
			}
	    // some_req == my_req when we come out of wait()
		}
		some_req = null;
	}

	public synchronized void wakeup(Request d) {
		this.some_req = d;
		notifyAll();
	}
	
	public void send(String channel)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "unary", channel, "");
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void send(String channel1, String channel2)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "binary", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive(String channel)  {
		// true = send, false = receive
		my_req = new Request(this, id, false, "unary", channel, "");
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive(String channel1, String channel2)  {
		// true = send, false = receive
		my_req = new Request(this, id, false, "binary", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}

	public abstract void chosen(String s);

}

public class Scheduler extends Thread {
	
	String scheduled;
	int count = 0;
	String waitlist = "";
	Random ran = new Random();
	
	LinkedList<Request> l = new LinkedList<Request>();

	public void run() {
		while (true) {
			schedule();
		}
	}
	
	synchronized void enqueue(Request r) {
		l.addLast(r);
		notifyAll();
	}
	
	synchronized void schedule() {
		
	    Request rem_r1 = null;   // requests to be removed
	    Request rem_r2 = null;
	    
		print_wait_list();
		
		try { while (l.size() < 2)  // removed the match_found check
				wait();
		} 
		catch (InterruptedException e) {}

		for (Request r1 : l) {
			for (Request r2 : l) {
				if (r1.cmd == !r2.cmd) {
					
					String r1_cmd, r2_cmd;

					if (r1.cmd == true) {
						r1_cmd = "send";
						r2_cmd = "receive";
					} else {
						r2_cmd = "send";
						r1_cmd = "receive";
					}

					if (r1.type.equals("unary") && r2.type.equals("unary")) {
						
						if (r1.channel1.equals(r2.channel1))  {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							unary_unary(r1, r2, r1_cmd, r2_cmd);
						}
					}

					else if (r1.type.equals("unary")  && r2.type.equals("binary")) {

						if (r1.channel1.equals(r2.channel1)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
						}

						else if (r1.channel1.equals(r2.channel2)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							unary_binary(r2, r1, r2_cmd, r1_cmd, r1.channel1);
						}
					}

					else if (r1.type.equals("binary") && r2.type.equals("unary")) {

						if (r2.channel1.equals(r1.channel1)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							unary_binary(r1, r2, r1_cmd, r2_cmd, r2.channel1);
						}
						else if (r2.channel1.equals(r1.channel2)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							unary_binary(r1, r2, r1_cmd, r2_cmd, r2.channel1);
						}
					}

					else if (r1.type.equals("binary") && r2.type.equals("binary")) {
						if (r1.channel1.equals(r2.channel1) && r1.channel2.equals(r2.channel2)
								|| r1.channel1.equals(r2.channel2) && r2.channel1.equals(r1.channel2)) {
							int r = ran.nextInt(9999) % 2;
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							if (r == 0)
								binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel1);
							else
								binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel2);
						}

						// no need for random selection since there is only one
						// match

						else if (r1.channel1.equals(r2.channel1) || r1.channel1.equals(r2.channel2)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel1);
						}

						else if (r2.channel1.equals(r1.channel2) || r2.channel2.equals(r1.channel2)) {
							rem_r1 = r1;  // must remove r1 and r2 outside for
							rem_r2 = r2;
							binary_binary(r1, r2, r1_cmd, r2_cmd, r1.channel2);
						}
					}
				  }
				if (rem_r1 != null) break;
			}
			if (rem_r1 != null) break;
		}
		if (rem_r1 != null) l.remove(rem_r1);
		if (rem_r2 != null) l.remove(rem_r2);
	}
	
	void unary_unary (Request r1, Request r2, String r1_cmd, String r2_cmd) {
			count++;
			System.out.println("	Schedule " + count + " ==> " + r1_cmd + "-" + r1.channel1
					+ "  and  " + r2_cmd + "-" + r2.channel1 + "\n");
			r1.process.wakeup(r1);
			r2.process.wakeup(r2);
			scheduled = r1.channel1;
			return;
	}
	
	void unary_binary(Request r1, Request r2, String r1_cmd, String r2_cmd, String chan) {
		// r1 is binary and r2 is unary
		count++;
		System.out.println("	Schedule " + count + " ==> "  + (r2_cmd) + "-"
				+ r2.channel1 + "  and  "  + (r1_cmd) + "-(" + r1.channel1 + "|"
				+ r1.channel2 + ")\n");
		r1.process.chosen(chan);
		r1.process.wakeup(r1);
		r2.process.wakeup(r2);
		scheduled = chan;
	}
	
	void binary_binary(Request r1, Request r2, String r1_cmd, String r2_cmd, String chan) {
		   count++;
		   System.out.println("	Schedule " + count + " ==> " + (r1_cmd) + "-("
				+ r1.channel1 + "|" + r1.channel2 + ")  and  " + (r2_cmd) + "-("
				+ r2.channel1 + "|" + r2.channel2 + ")\n");
			r1.process.chosen(chan);
			r2.process.chosen(chan);
			r1.process.wakeup(r1);
			r2.process.wakeup(r2);
			scheduled = chan;
	  }
	
	void print_wait_list() {
		waitlist = "";
		for (Request r : l) {
			String r_cmd;
			if (r.cmd)
				r_cmd = "send";
			else
				r_cmd = "receive";
			if (r.type == "unary")
				waitlist = waitlist + (r_cmd) + "-" + r.channel1 + ";   ";
			else
				waitlist = waitlist + (r_cmd) + "-(" + r.channel1 + "|" + r.channel2 + ");   ";
			r = null;
		}
		
		System.out.println(waitlist + "\n");
	}
	
}

