package Scheduler;

import java.util.ArrayList;

public abstract class Process implements Runnable {

	public Scheduler scheduler;
	protected String id;
	protected Request my_req = null;
	Request some_req = null;
	protected String chosen;

	public synchronized void pause() {
		while (some_req == null) {
			try {
				wait();
			} catch (InterruptedException e) {
			}
	    // some_req == my_req when we come out of wait()
		}
		some_req = null;
	}

	public synchronized void wakeup(Request d) {
		some_req = d;
		notify();
	}
	
	public int num_waiting(String cmd, String channel) {
		return scheduler.count(cmd,channel);
	}
	
	public boolean is_waiting(String cmd, String channel) {
		return scheduler.count(cmd,channel) > 0;
	}
	
	public void await(String cmd, String channel1, String channel2) {
		boolean b;
		if (cmd.equals("send"))
			 b = true;
		else b = false;
		my_req = new Request(this, id, b, "await", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
	}
	
	public void await(Guard g) {
		my_req = new Request(this, id, "await_guard", g);
		scheduler.enqueue(my_req);
		pause();
	}
	
	public void send(String channel)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "unary", channel);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void send_data(String channel, Object data)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "unary", channel, data);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void send(String channel1, String channel2)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "binary", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void send_data(String channel1, String channel2, Object data)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "binary", channel1, channel2, data);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive(String channel)  {
		// true = send, false = receive
		my_req = new Request(this, id, false, "unary", channel);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive_guard(Guard g, String channel)  {
		// true = send, false = receive
		my_req = new Request(this, id, false, "unary", channel, g);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive_guard(Guard g, String channel1, String channel2)  {
		// true = send, false = receive
	    my_req = new Request(this, id, false, "binary", channel1, channel2, g);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive_guard(Guard g1, String channel1, Guard g2, String channel2)  {
		// true = send, false = receive
	    my_req = new Request(this, id, false, "binary", channel1, channel2, g1, g2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive(String channel1, String channel2)  {
		// true = send, false = receive
	   my_req = new Request(this, id, false, "binary", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	
	public void send_or_receive(String channel1, String channel2)  {
		// true = send, false = receive
		my_req = new Request(this, id, true, "mixed", channel1, channel2);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive_or_send(String channel1, String channel2)  {
		// true = send, false = receive
		// channel1 is send and channel2 is receive
		my_req = new Request(this, id, true, "mixed", channel2, channel1);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void send_or_receive_data(String channel1, Object data1, String channel2)  {
		// true = send, false = receive
		// channel1 is send and channel2 is receive
		my_req = new Request(this, id, true, "mixed", channel1, channel2, data1);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public void receive_or_send_data(String channel1, String channel2, Object data1)  {
		// true = send, false = receive
		// channel1 is send and channel2 is receive
		my_req = new Request(this, id, true, "mixed", channel2, channel1, data1);
		scheduler.enqueue(my_req);
		pause();
		//my_req.process = null;
	}
	
	public Object get_data() {
		return my_req.data1;
	}
	
	public void chosen(String s) {chosen = s;}
}