package org.apache.tomcat.util.digester;

import java.security.Permission;
import java.util.PropertyPermission;

import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.security.PermissionCheck;

class SystemPropertySource implements IntrospectionUtils.PropertySource {
	
	Digester digester = null;
	SystemPropertySource(Digester d){
		digester = d;
	}
    @Override
    public String getProperty(String key) {
        ClassLoader cl = digester.getClassLoader();
        if (cl instanceof PermissionCheck) {
            Permission p = new PropertyPermission(key, "read");
            if (!((PermissionCheck) cl).check(p)) {
                return null;
            }
        }
        return System.getProperty(key);
    }
}
