/*
 * Decompiled with CFR 0.152.
 */
package control_injector;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ByteCodeWriter
extends ClassWriter {
    ClassLoader classLoader;
    CCLoader ccl;
    boolean isPackage;

    public ByteCodeWriter(ClassReader classReader, ClassLoader loader, HashSet<String> instrumentList, boolean isPkg, int writerFlag) {
        super(classReader, writerFlag);
        this.classLoader = loader;
        this.isPackage = isPkg;
        this.ccl = new CCLoader(loader, instrumentList, isPkg);
    }

    @Override
    protected String getCommonSuperClass(String className1, String className2) {
        Class<?> class1 = null;
        Class<?> class2 = null;
        String classN1 = className1.replace('/', '.');
        String classN2 = className2.replace('/', '.');
        try {
            class1 = this.ccl.loadClass(classN1);
        }
        catch (Error | Exception e) {
            System.err.println("Exception or Error :  " + e.getMessage());
            System.err.println("Retrying");
            try {
                class1 = Class.forName(classN1);
                if (class1 != null) {
                    System.err.println("Succeeded in loading : " + class1.getName());
                }
            }
            catch (Error | Exception e1) {
                System.err.println(e1.getMessage());
            }
        }
        try {
            class2 = this.ccl.loadClass(classN2);
        }
        catch (Error | Exception e2) {
            System.err.println("Exception or Error :  " + e2.getMessage());
            System.err.println("Retrying");
            try {
                class2 = Class.forName(classN2);
                if (class2 != null) {
                    System.err.println("Succeeded in loading : " + class2.getName());
                }
            }
            catch (Error | Exception e3) {
                System.err.println(e3.getMessage());
            }
        }
        if (class1.isAssignableFrom(class2)) {
            return className1;
        }
        if (class2.isAssignableFrom(class1)) {
            return className2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }

    class CCLoader
    extends ClassLoader {
        HashMap<String, Class> classCache;
        HashSet<String> packageNames;
        HashSet<String> classNames;
        boolean isPackage;

        public CCLoader(ClassLoader parent, HashSet<String> instrumentList, boolean isPkg) {
            super(parent);
            this.packageNames = new HashSet();
            this.classNames = new HashSet();
            this.isPackage = isPkg;
            if (this.isPackage) {
                for (String pack : instrumentList) {
                    this.packageNames.add(pack.replace(File.separatorChar, '.'));
                }
            } else {
                for (String clazz : instrumentList) {
                    this.classNames.add(clazz.replace(File.separatorChar, '.'));
                }
            }
            this.classCache = new HashMap();
        }

        private Class getClass(String name) throws ClassNotFoundException {
            String file = name.replace('.', File.separatorChar) + ".class";
            byte[] b = null;
            if (this.classCache.containsKey(name)) {
                return this.classCache.get(name);
            }
            try {
                b = this.loadClassFileData(file);
                Class<?> c = this.defineClass(name, b, 0, b.length);
                this.resolveClass(c);
                this.classCache.put(name, c);
                return c;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            boolean available = false;
            if (this.isPackage) {
                for (String pack : this.packageNames) {
                    if (!name.startsWith(pack)) continue;
                    available = true;
                    break;
                }
            } else if (this.classNames.contains(name)) {
                available = true;
            }
            if (available) {
                return this.getClass(name);
            }
            return super.loadClass(name);
        }

        private byte[] loadClassFileData(String name) throws IOException {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(name);
            int size = stream.available();
            byte[] buff = new byte[size];
            DataInputStream in = new DataInputStream(stream);
            in.readFully(buff);
            in.close();
            return buff;
        }
    }
}

