/*
 * Decompiled with CFR 0.152.
 */
package control_injector;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public final class ControlInjector_InMemory {
    private static long traceCounter = 1L;
    private static boolean methodCallToUpdate = false;
    public static BufferedWriter log = null;
    public static String logFilePath = "CF_Trace.csv";
    public static boolean debug = false;
    private static int file_write_count = 1;
    private static Queue<String> logQueue = new LinkedList<String>();
    private static String traceCall = "no method call data\n";
    private static String traceEnt = "no method entered data\n";
    private static ArrayList<String> traceCallBuffer = new ArrayList();
    private static final Logger LOGGER = Logger.getLogger("CONTROL_LOGGER");

    public static void getCurrentMethodName() {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        String[] classParts = e.getClassName().split("[.]");
        String className = classParts[classParts.length - 1];
        String method = className + "." + e.getMethodName();
        String details = "context = cfi,currentMethod=" + method;
        ControlInjector_InMemory.jiveBciLog(details, "Field Write", e.getFileName(), Thread.currentThread().getName());
    }

    public static void jiveBciSetup(String path, String debug1, Integer write_count) {
        logFilePath = path;
        debug = Boolean.parseBoolean(debug1);
        file_write_count = write_count;
    }

    public static void jiveBciInit() {
        try {
            if (log != null) {
                if (debug) {
                    LOGGER.info("[JiveBciInit] Log not null .. closing stream");
                }
                log.flush();
                log.close();
                log = null;
            }
            if (debug) {
                LOGGER.info("[JiveBciInit]  Log is null ... init file open");
            }
            log = new BufferedWriter(new FileWriter(logFilePath, true));
            if (debug) {
                LOGGER.info("[JiveBciInit] Opened tracefile in path:" + logFilePath);
            }
            String systemInit = "\"SYSTEM\", \"1\", \"SYSTEM\", \"System Start\", \" \" \n";
            log.write(systemInit);
            log.flush();
        }
        catch (IOException e) {
            System.err.println("[JiveBciInit]  Error while opening fileWriter ! Cannot write the execution trace to log file!!");
            e.printStackTrace();
        }
    }

    public static synchronized void jiveBciLog(String details, String event, String source, String thread) {
        String trace = "bci log - no data ";
        if (event.equalsIgnoreCase("Method Call") || event.equalsIgnoreCase("Method Entered") || event.equalsIgnoreCase("Object Initialized")) {
            ControlInjector_InMemory.jiveBciMethodLog(details, event, source, thread);
            return;
        }
        trace = "\"" + thread + "\", \"" + String.valueOf(++traceCounter) + "\", \"" + source + "\", \"" + event + "\", \"" + details + "\"\n";
        if (debug) {
            LOGGER.info("[JiveBciLog]" + trace);
        }
        if (trace.contains("*jive_uid*")) {
            traceCallBuffer.add(traceCall);
        } else {
            ControlInjector_InMemory.writeToLog(trace);
        }
    }

    public static synchronized void jiveBciMethodLog(String details, String event, String source, String thread) {
        switch (event) {
            case "Method Call": {
                traceCall = "\"" + thread + "\", \"" + String.valueOf(++traceCounter) + "\", \"" + source + "\", \"" + event + "\", \"" + details + "\"\n";
                if (traceCall.contains("@@@") || traceCall.contains("*jive_uid*")) {
                    methodCallToUpdate = true;
                    traceCallBuffer.add(traceCall);
                } else {
                    ControlInjector_InMemory.writeToLog(traceCall);
                    traceCall = "no method call data\n";
                }
                if (!debug) break;
                LOGGER.info("[JiveMethodBciLog]  Method Call - " + traceCall);
                break;
            }
            case "Method Entered": {
                int index;
                if (!traceCallBuffer.isEmpty() && methodCallToUpdate && (traceCall = traceCallBuffer.get(index = traceCallBuffer.size() - 1)).contains("@@@")) {
                    traceCallBuffer.remove(index);
                    traceCall = traceCall.replace("@@@", details);
                }
                traceEnt = "\"" + thread + "\", \"" + String.valueOf(++traceCounter) + "\", \"" + source + "\", \"" + event + "\", \"" + details + "\"\n";
                if (debug) {
                    LOGGER.info(" [JiveMethodBciLog]  Method Entered - " + traceEnt);
                }
                if (details.equalsIgnoreCase("*jive_uid*")) {
                    traceCallBuffer.add(traceCall);
                    traceCallBuffer.add(traceEnt);
                    break;
                }
                if (traceCall.equalsIgnoreCase("no method call data\n")) {
                    LOGGER.info("[JiveMethodBciLog]  No Method Call data");
                } else {
                    ControlInjector_InMemory.writeToLog(traceCall);
                }
                if (traceEnt.equalsIgnoreCase("no method entered data\n")) {
                    LOGGER.info("[JiveMethodBciLog]  No Method Entered data");
                } else {
                    ControlInjector_InMemory.writeToLog(traceEnt);
                }
                traceCall = "no method call data\n";
                traceEnt = "no method entered data\n";
                break;
            }
            case "Object Initialized": {
                String traceObjInit = "\"" + thread + "\", \"" + String.valueOf(0) + "\", \"" + source + "\", \"" + event + "\", \"" + details + "\"\n";
                if (debug) {
                    LOGGER.info("**Method Call in Obj init - " + traceCall);
                    LOGGER.info("**Method Entered in Obj init - " + traceEnt);
                }
                Iterator<String> it = traceCallBuffer.iterator();
                while (it.hasNext()) {
                    String trace = it.next();
                    it.remove();
                    if (trace.contains("@@@")) {
                        trace = trace.replace("@@@", details);
                    } else if (trace.contains("*jive_uid*")) {
                        trace = trace.replace("*jive_uid*", details);
                    }
                    if (debug) {
                        LOGGER.info("#Method trace  - " + trace);
                        LOGGER.info("#Obj init Sample trace not written to file- " + traceObjInit);
                    }
                    if (trace.equalsIgnoreCase("no method call data\n")) {
                        LOGGER.info("[JiveMethodBciLog]  No Method Call data");
                        continue;
                    }
                    ControlInjector_InMemory.writeToLog(trace);
                }
                break;
            }
        }
    }

    private static synchronized void writeToLog(String trace) {
        logQueue.add(trace);
        if (logQueue.size() == file_write_count) {
            if (debug) {
                LOGGER.info("[WriteToLog] Flushing the Queue to File");
            }
            try {
                if (log == null) {
                    ControlInjector_InMemory.jiveBciInit();
                }
                while (logQueue.size() > 0) {
                    String tr = logQueue.poll();
                    if (tr == null) continue;
                    log.write(tr);
                }
                log.flush();
                if (debug) {
                    LOGGER.info("[WriteToLog] Flushing Completed");
                }
            }
            catch (IOException e) {
                ControlInjector_InMemory.jiveBciInit();
                try {
                    log.write(trace);
                    log.flush();
                }
                catch (IOException e1) {
                    System.err.println("Error in appending to File !");
                    e1.printStackTrace();
                }
            }
        }
    }

    public static synchronized void jiveBciFinish() {
        try {
            if (log == null) {
                ControlInjector_InMemory.jiveBciInit();
            }
            while (logQueue.size() > 0) {
                String tr = logQueue.poll();
                if (tr == null) continue;
                log.write(tr);
            }
            log.flush();
            if (log != null) {
                String systemEnd = "\"SYSTEM\", \"" + String.valueOf(++traceCounter) + "\", \"SYSTEM\", \"System End\", \" \" \n";
                log.write(systemEnd);
                log.flush();
                log.close();
                log = null;
            }
        }
        catch (IOException e) {
            System.err.println("Error in Closing File Stream!");
            e.printStackTrace();
        }
    }
}

