/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.models;

import edu.buffalo.cse.jive.finiteStateMachine.models.Event;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class InputFileParser {
    private Set<String> allFields = new TreeSet<String>();
    private BlockingQueue<Event> events = new LinkedBlockingQueue<Event>();

    public InputFileParser(String fileName) {
        this.parseFile(fileName);
    }

    private void parseFile(String fileName) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
            int counter = 0;
            String lastMethod = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("Method Call")) {
                    lastMethod = line.substring(line.indexOf("target=") + 7);
                    lastMethod = lastMethod.substring(lastMethod.indexOf(35) + 1).replace("\"", "").trim();
                    lastMethod = String.valueOf(lastMethod) + ":" + counter++;
                }
                if (!line.contains("Field Write")) continue;
                String[] tokens = line.split(",");
                String object = tokens[4].substring(tokens[4].indexOf("=") + 1).replace("\"", "").trim();
                String field = tokens[5].substring(0, tokens[5].indexOf("=")).replace("\"", "").trim();
                String value = tokens[5].substring(tokens[5].indexOf("=") + 1).replace("\"", "").trim();
                String fld = String.valueOf(object.replace("/", ".")) + "." + field;
                this.events.add(new Event(fld, value, lastMethod));
                this.allFields.add(fld);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Set<String> getAllFields() {
        return this.allFields;
    }

    public BlockingQueue<Event> getEvents() {
        return this.events;
    }
}

