/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.models;

import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.value.ValueExpression;
import java.util.LinkedHashMap;
import java.util.Map;

public class State {
    private Map<String, ValueExpression> vector;
    private Status status = Status.VALID;

    public State() {
        this.vector = new LinkedHashMap<String, ValueExpression>();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : this.vector.keySet()) {
            stringBuilder.append(this.vector.get(key));
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof State)) {
            return false;
        }
        State newState = (State)obj;
        return this.toString().equals(newState.toString());
    }

    public int hashCode() {
        int hash = 0;
        for (String s : this.vector.keySet()) {
            hash ^= s.hashCode() ^ this.vector.get(s).hashCode();
        }
        return hash;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void reset() {
        this.status = Status.VALID;
    }

    public State copy() {
        State state = new State();
        state.setVector(new LinkedHashMap<String, ValueExpression>(this.vector));
        return state;
    }

    public Map<String, ValueExpression> getVector() {
        return this.vector;
    }

    public void setVector(Map<String, ValueExpression> vector) {
        this.vector = vector;
    }

    public static enum Status {
        MARKED,
        VALID,
        INVALID;

    }
}

