/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.models;

import edu.buffalo.cse.jive.finiteStateMachine.models.State;
import edu.buffalo.cse.jive.finiteStateMachine.util.Pair;
import edu.buffalo.cse.jive.finiteStateMachine.util.TemporaryDataTransporter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TransitionBuilder {
    private StringBuilder transitions = new StringBuilder();
    private State rootState;
    private Map<State, Set<State>> states;

    public TransitionBuilder(State rootState, Map<State, Set<State>> states) {
        this.transitions.append("@startuml\n");
        this.rootState = rootState;
        this.states = states;
    }

    private void addInitialState(State state, State.Status status) {
        if (status.equals((Object)State.Status.VALID)) {
            this.transitions.append("(*) --> \"" + state.toString() + "\"");
        } else if (status.equals((Object)State.Status.MARKED)) {
            this.transitions.append("(*) --> \"" + state.toString() + "\"" + " #LimeGreen");
        } else {
            this.transitions.append("(*) --> \"" + state.toString() + "\"" + " #red");
        }
        this.addNewLine();
    }

    public String getTransitions() {
        return new StringBuilder(this.transitions).append("@enduml\n").toString();
    }

    private void addTransition(State state1, State state2, State.Status status) {
        if (status.equals((Object)State.Status.INVALID)) {
            this.addColorTransition(state1, state2, "red");
        } else {
            this.addNoColorTransition(state1, state2);
        }
    }

    private void addColorTransition(State state1, State state2, String color) {
        String s = "\"" + state1.toString() + "\"" + " --> " + "\"" + state2.toString() + "\"" + " #" + color;
        this.transitions.append(s);
        this.addNewLine();
    }

    private void addNoColorTransition(State state1, State state2) {
        String s = "\"" + state1.toString() + "\"" + " --> " + "\"" + state2.toString() + "\"";
        this.transitions.append(s);
        this.addNewLine();
    }

    private void addColorTransitionWithArrowBetweenSameStates(State state1, State state2, String backgroundColor, String arrowColor) {
        Pair<State, State> pair = new Pair<State, State>(state1, state2);
        String s = "\"" + state1.toString() + "\"";
        s = TemporaryDataTransporter.getPath().contains(pair) ? String.valueOf(s) + " -[#" + arrowColor + "]-> " : String.valueOf(s) + " --> ";
        s = String.valueOf(s) + "\"" + state2.toString() + "\"";
        if (backgroundColor.length() > 0) {
            s = String.valueOf(s) + " #" + backgroundColor;
        }
        this.transitions.append(s);
        this.addNewLine();
    }

    private void addNewLine() {
        this.transitions.append("\n");
    }

    public void build() {
        this.addInitialState(this.rootState, this.rootState.getStatus());
        this.buildTransitions(this.rootState);
    }

    private void buildTransitions(State rootState) {
        LinkedList<State> toBeVisited = new LinkedList<State>();
        HashSet<Pair<State, State>> traversedPath = new HashSet<Pair<State, State>>();
        HashSet<State> visited = new HashSet<State>();
        toBeVisited.add(rootState);
        while (!toBeVisited.isEmpty()) {
            State curr = (State)toBeVisited.poll();
            for (State next : this.states.get(curr)) {
                if (!traversedPath.add(new Pair<State, State>(curr, next))) continue;
                if (next.getStatus().equals((Object)State.Status.MARKED) && TemporaryDataTransporter.shouldHighlight) {
                    this.addColorTransitionWithArrowBetweenSameStates(curr, next, "LimeGreen", "green");
                } else {
                    this.addTransition(curr, next, next.getStatus());
                }
                if (!visited.add(next)) continue;
                toBeVisited.add(next);
            }
        }
    }
}

