/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.monitor;

import edu.buffalo.cse.jive.finiteStateMachine.models.Context;
import edu.buffalo.cse.jive.finiteStateMachine.models.Event;
import edu.buffalo.cse.jive.finiteStateMachine.models.State;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.expression.Expression;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.temporal.EExpression;
import edu.buffalo.cse.jive.finiteStateMachine.util.TemporaryDataTransporter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public abstract class Monitor
implements Runnable {
    private Set<String> keyFields;
    private BlockingQueue<Event> source;
    private Map<State, Set<State>> states;
    private State rootState;
    private State previousState;
    private boolean shouldConsolidateByMethod;
    private Map<String, State> consolidatedStateMap;

    public Monitor(Set<String> keyFields, BlockingQueue<Event> source, boolean shouldConsolidateByMethod) {
        this.keyFields = keyFields;
        this.source = source;
        this.shouldConsolidateByMethod = shouldConsolidateByMethod;
        this.states = new HashMap<State, Set<State>>();
        this.consolidatedStateMap = new LinkedHashMap<String, State>();
        this.previousState = new State();
        for (String field : this.getKeyFields()) {
            if (Event.abbreviations.containsKey(field)) {
                this.previousState.getVector().put(Event.abbreviations.get(field), null);
                continue;
            }
            this.previousState.getVector().put(field, null);
        }
    }

    protected boolean buildStates(Event event) {
        boolean result = false;
        if (this.keyFields.contains(event.getField()) || this.keyFields.contains(this.getEventKey(event.getField()))) {
            State newState = this.previousState.copy();
            newState.getVector().put(event.getField(), event.getValue());
            if (!newState.getVector().values().contains(null) && !this.previousState.getVector().values().contains(null)) {
                result = this.states.get(this.previousState).add(newState);
                if (!this.states.containsKey(newState)) {
                    this.states.put(newState, new LinkedHashSet());
                }
            } else if (!newState.getVector().values().contains(null) && this.previousState.getVector().values().contains(null)) {
                this.states.put(newState, new LinkedHashSet());
                this.rootState = newState;
            }
            this.previousState = newState;
        }
        return result;
    }

    protected void generateConsolidateEventMap(Event event) {
        if (this.keyFields.contains(event.getField()) || this.keyFields.contains(this.getEventKey(event.getField()))) {
            State newState = this.previousState.copy();
            newState.getVector().put(event.getField(), event.getValue());
            this.consolidatedStateMap.put(event.getMethod(), newState);
            this.previousState = newState;
        }
    }

    protected void buildConsolidatedStates() {
        this.previousState = new State();
        for (String field : this.getKeyFields()) {
            if (Event.abbreviations.containsKey(field)) {
                this.previousState.getVector().put(Event.abbreviations.get(field), null);
                continue;
            }
            this.previousState.getVector().put(field, null);
        }
        int stateCount = 0;
        for (String key : this.consolidatedStateMap.keySet()) {
            State newState = this.consolidatedStateMap.get(key);
            if (stateCount == 0) {
                this.states.put(newState, new LinkedHashSet());
                this.rootState = newState;
            } else {
                this.states.get(this.previousState).add(newState);
                if (!this.states.containsKey(newState)) {
                    this.states.put(newState, new LinkedHashSet());
                }
            }
            this.previousState = newState;
            ++stateCount;
        }
    }

    private String getEventKey(String value) {
        if (Event.abbreviations == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : Event.abbreviations.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean validate(List<Expression> expressions) throws Exception {
        boolean result = this.validate(this.rootState, expressions);
        if (result && expressions.get(0) instanceof EExpression && TemporaryDataTransporter.shouldHighlight) {
            this.rootState.setStatus(State.Status.MARKED);
        } else if (result) {
            this.rootState.setStatus(State.Status.VALID);
        } else {
            this.rootState.setStatus(State.Status.INVALID);
        }
        return result;
    }

    public void resetStates() {
        for (State key : this.states.keySet()) {
            for (State state : this.states.get(key)) {
                state.reset();
            }
        }
    }

    private boolean validate(State root, List<Expression> expressions) {
        boolean valid = true;
        Context thisContext = new Context(root, null, this.states);
        if (expressions.get(0) instanceof EExpression) {
            thisContext = new Context(root, null, this.states, true);
        }
        for (Expression expression : expressions) {
            boolean bl = valid = expression.evaluate(thisContext) != false && valid;
        }
        return valid;
    }

    protected void printStates() {
        for (State key : this.states.keySet()) {
            System.out.print(key + " : ");
            for (State state : this.states.get(key)) {
                System.out.print(state + " ");
            }
            System.out.println();
        }
    }

    public Set<String> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(Set<String> keyFields) {
        this.keyFields = keyFields;
    }

    public BlockingQueue<Event> getSource() {
        return this.source;
    }

    public void setSource(BlockingQueue<Event> source) {
        this.source = source;
    }

    public Map<State, Set<State>> getStates() {
        return this.states;
    }

    public void setStates(Map<State, Set<State>> states) {
        this.states = states;
    }

    public State getRootState() {
        return this.rootState;
    }

    public void setRootState(State rootState) {
        this.rootState = rootState;
    }

    public boolean isShouldConsolidateByMethod() {
        return this.shouldConsolidateByMethod;
    }

    public void setShouldConsolidateByMethod(boolean shouldConsolidateByMethod) {
        this.shouldConsolidateByMethod = shouldConsolidateByMethod;
    }
}

