/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.parser.expression.temporal;

import edu.buffalo.cse.jive.finiteStateMachine.models.Context;
import edu.buffalo.cse.jive.finiteStateMachine.models.State;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.expression.Expression;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.expression.TernaryExpression;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class PathExpression
extends TernaryExpression<Expression, Expression, Expression> {
    public PathExpression(Expression expressionA, Expression expressionB, Expression expressionC) {
        super(expressionA, expressionB, expressionC);
    }

    @Override
    public Boolean evaluate(Context context) {
        Result result = this.evaluate(context.getCurrentState(), context.getStates());
        if (result.equals((Object)Result.TRUE_PATH)) {
            return true;
        }
        return false;
    }

    private Result evaluate(State rootState, Map<State, Set<State>> states) {
        boolean currentResult = false;
        LinkedList<State> toBeVisited = new LinkedList<State>();
        Stack<State> visited = new Stack<State>();
        toBeVisited.add(rootState);
        visited.add(rootState);
        State sourceState = new State();
        while (!toBeVisited.isEmpty()) {
            State curr = (State)toBeVisited.poll();
            for (State next : states.get(curr)) {
                if (visited.contains(next)) continue;
                boolean isMatch = ((Expression)this.getExpressionA()).evaluate(new Context(next, null, states));
                if (isMatch) {
                    sourceState = next;
                    currentResult = true;
                    break;
                }
                visited.push(next);
                toBeVisited.add(next);
            }
            if (((Expression)this.getExpressionA()).evaluate(new Context(curr, null, states)).booleanValue()) {
                sourceState = curr;
                currentResult = true;
            }
            if (currentResult) break;
        }
        if (!currentResult) {
            return Result.NOT_FOUND;
        }
        return this.findTargetThroughMedium(sourceState, states, false, new HashSet<State>());
    }

    private Result findTargetThroughMedium(State curr, Map<State, Set<State>> states, boolean foundMid, HashSet<State> visited) {
        Result result = Result.NOT_FOUND;
        boolean isTarget = ((Expression)this.getExpressionC()).evaluate(new Context(curr, null, states));
        if (isTarget) {
            if (foundMid) {
                return Result.TRUE_PATH;
            }
            return Result.WRONG_PATH;
        }
        if (!foundMid) {
            foundMid = ((Expression)this.getExpressionB()).evaluate(new Context(curr, null, states));
        }
        visited.add(curr);
        if (!states.get(curr).isEmpty()) {
            for (State next : states.get(curr)) {
                if (visited.contains(next)) continue;
                Result tempResult = this.findTargetThroughMedium(next, states, foundMid, visited);
                if (tempResult.equals((Object)Result.WRONG_PATH)) {
                    return Result.WRONG_PATH;
                }
                if (!tempResult.equals((Object)Result.TRUE_PATH)) continue;
                result = tempResult;
            }
        }
        visited.remove(curr);
        return result;
    }

    static enum Result {
        NOT_FOUND,
        TRUE_PATH,
        WRONG_PATH;

    }
}

