/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.parser.expression.value;

import edu.buffalo.cse.jive.finiteStateMachine.models.Context;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.expression.Expression;

public abstract class ValueExpression
extends Expression
implements Comparable<ValueExpression> {
    private Object value;

    @Override
    public Boolean evaluate(Context context) {
        return true;
    }

    public ValueExpression(Object value) {
        this.setEvaluatable(false);
        this.value = value;
        this.hashCode();
    }

    public ValueExpression() {
        this.setEvaluatable(false);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public int compareTo(ValueExpression valueExpression) {
        Object value1 = this.getValue();
        Object value2 = valueExpression.getValue();
        switch (value1.getClass().getSimpleName()) {
            case "Double": {
                return new Double((Double)value1).compareTo(new Double((Double)value2));
            }
            case "String": {
                return new String((String)value1).compareTo(new String((String)value2));
            }
            case "Integer": {
                return new Integer((Integer)value1).compareTo(new Integer((Integer)value2));
            }
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public Object add(ValueExpression valueExpression) {
        Object value1 = this.getValue();
        Object value2 = valueExpression.getValue();
        switch (value1.getClass().getSimpleName()) {
            case "Double": {
                return new Double((Double)value1) + new Double((Double)value2);
            }
            case "String": {
                return String.valueOf(new String((String)value1)) + new String((String)value2);
            }
            case "Integer": {
                return new Integer((Integer)value1) + new Integer((Integer)value2);
            }
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public Object subtract(ValueExpression valueExpression) {
        Object value1 = this.getValue();
        Object value2 = valueExpression.getValue();
        switch (value1.getClass().getSimpleName()) {
            case "Double": {
                return new Double((Double)value1) - new Double((Double)value2);
            }
            case "Integer": {
                return new Integer((Integer)value1) - new Integer((Integer)value2);
            }
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public Object divide(ValueExpression valueExpression) {
        Object value1 = this.getValue();
        Object value2 = valueExpression.getValue();
        switch (value1.getClass().getSimpleName()) {
            case "Double": {
                return new Double((Double)value1) / new Double((Double)value2);
            }
            case "Integer": {
                return new Integer((Integer)value1) / new Integer((Integer)value2);
            }
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public Object multiply(ValueExpression valueExpression) {
        Object value1 = this.getValue();
        Object value2 = valueExpression.getValue();
        switch (value1.getClass().getSimpleName()) {
            case "Double": {
                return new Double((Double)value1) * new Double((Double)value2);
            }
            case "Integer": {
                return new Integer((Integer)value1) * new Integer((Integer)value2);
            }
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueExpression) {
            ValueExpression val = (ValueExpression)obj;
            return this.getValue().equals(val.getValue());
        }
        throw new IllegalArgumentException("Type mismatch in properties");
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

