/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.views;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Scanner;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class FSMAbstractionGranularity
extends ViewPart {
    public static final String ID = "finite_state_machine.views.FiniteStateMachine";
    private TableViewer viewer;
    private IStatusLineManager statusLineManager;
    private Display display;
    private ScrolledComposite rootScrollComposite;
    private Composite mainComposite;
    private Label fileLabel;
    private Text fileText;
    private Combo attributeList;
    private Button browseButton;
    private Button exportButton;
    Composite imageComposite;
    Composite image2Composite;
    private Image image;
    public boolean horizontal;
    public boolean vertical;
    private Label kvLabel;
    private Text kvText;
    private Label paLabel;
    private Text paText;
    private Button addButton;
    private Button resetButton;
    private Button drawButton;
    private Button ssChkBox;
    private Button startButton;
    private Button prevButton;
    private Button nextButton;
    private Button endButton;
    private Button startButton2;
    private Button prevButton2;
    private Button nextButton2;
    private Button endButton2;
    private Button[] granularity;
    private Label grLabel;
    private Label repeatLabel;
    private Text repeatText;
    private Button transitionCount;
    private Button aRun;
    StateDiagram sd;
    private Label kvSyntax;
    private Label kvSpace;
    private Label paSpace;
    private Label paSyntax;
    private StringBuffer sb;
    private String source;
    private int count;
    Browser browser;
    private Label canvasLabel;
    private Label byLabel;
    private Text hcanvasText;
    private Text vcanvasText;
    String svg;
    private Label tpLabel;
    private Text tpText;
    private Button tpButton;

    public void createPartControl(Composite parent) {
        this.statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.display = parent.getDisplay();
        GridLayout layoutParent = new GridLayout();
        layoutParent.numColumns = 1;
        parent.setLayout((Layout)layoutParent);
        this.rootScrollComposite = new ScrolledComposite(parent, 768);
        this.rootScrollComposite.setLayout((Layout)new GridLayout(1, false));
        this.rootScrollComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rootScrollComposite.setExpandHorizontal(true);
        this.rootScrollComposite.setExpandVertical(true);
        this.mainComposite = new Composite((Composite)this.rootScrollComposite, 0);
        this.rootScrollComposite.setContent((Control)this.mainComposite);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite browseComposite = new Composite(this.mainComposite, 0);
        browseComposite.setLayout((Layout)new GridLayout(5, false));
        browseComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.browseButton = new Button(browseComposite, 8);
        this.browseButton.setText("Browse");
        this.fileLabel = new Label(browseComposite, 4);
        this.fileLabel.setText("CSV File : ");
        this.fileText = new Text(browseComposite, 8);
        this.fileText.setBackground(Display.getCurrent().getSystemColor(15));
        GridData gd = new GridData();
        gd.widthHint = 650;
        this.fileText.setLayoutData((Object)gd);
        Composite kvComposite = new Composite(this.mainComposite, 0);
        kvComposite.setLayout((Layout)new GridLayout(2, false));
        kvComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.kvLabel = new Label(kvComposite, 4);
        this.kvLabel.setText("Key Attributes");
        this.kvText = new Text(kvComposite, 2052);
        GridData gd5 = new GridData();
        gd5.widthHint = 650;
        this.kvText.setLayoutData((Object)gd5);
        this.kvSpace = new Label(kvComposite, 4);
        this.kvSpace.setText("                     ");
        this.kvSyntax = new Label(kvComposite, 4);
        this.kvSyntax.setText("   class:index->field,......,class:index->field");
        Composite evComposite = new Composite(this.mainComposite, 0);
        evComposite.setLayout((Layout)new GridLayout(10, false));
        evComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.attributeList = new Combo(evComposite, 2052);
        this.addButton = new Button(evComposite, 8);
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Adds the key attribute selected");
        this.resetButton = new Button(evComposite, 8);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("Clears the key attributes");
        this.drawButton = new Button(evComposite, 8);
        this.drawButton.setText("Draw");
        this.drawButton.setToolTipText("Draws the state diagram");
        this.exportButton = new Button(evComposite, 8);
        this.exportButton.setText("Export");
        this.exportButton.setToolTipText("Exports the state diagram");
        this.ssChkBox = new Button(evComposite, 32);
        this.ssChkBox.setSelection(false);
        this.ssChkBox.setText("Step-by-step");
        this.startButton = new Button(evComposite, 8);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Start state");
        this.startButton.setEnabled(false);
        this.prevButton = new Button(evComposite, 8);
        this.prevButton.setText("Prev");
        this.prevButton.setToolTipText("Previous state");
        this.prevButton.setEnabled(false);
        this.nextButton = new Button(evComposite, 8);
        this.nextButton.setText("Next");
        this.nextButton.setToolTipText("Next state");
        this.nextButton.setEnabled(false);
        this.endButton = new Button(evComposite, 8);
        this.endButton.setText(" End ");
        this.endButton.setToolTipText("End state");
        this.endButton.setEnabled(false);
        Composite grComposite = new Composite(this.mainComposite, 0);
        grComposite.setLayout((Layout)new GridLayout(10, false));
        grComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.grLabel = new Label(grComposite, 4);
        this.grLabel.setText("Granularity");
        this.granularity = new Button[2];
        this.granularity[0] = new Button(grComposite, 16);
        this.granularity[0].setSelection(true);
        this.granularity[0].setText("Field");
        this.granularity[1] = new Button(grComposite, 16);
        this.granularity[1].setSelection(false);
        this.granularity[1].setText("Method");
        this.repeatLabel = new Label(grComposite, 4);
        this.repeatLabel.setText("       Mininmum Field Updates");
        this.repeatText = new Text(grComposite, 2052);
        GridData gd6 = new GridData();
        gd6.widthHint = 25;
        this.repeatText.setLayoutData((Object)gd6);
        this.repeatText.setText("1");
        this.transitionCount = new Button(grComposite, 32);
        this.transitionCount.setSelection(true);
        this.transitionCount.setText("Count transitions");
        this.aRun = new Button(grComposite, 32);
        this.aRun.setSelection(false);
        this.aRun.setText("Run");
        Composite paComposite = new Composite(this.mainComposite, 0);
        paComposite.setLayout((Layout)new GridLayout(2, false));
        paComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.paLabel = new Label(paComposite, 4);
        this.paLabel.setText("Abstraction");
        this.paText = new Text(paComposite, 2052);
        GridData gd5b = new GridData();
        gd5b.widthHint = 400;
        this.paText.setLayoutData((Object)gd5b);
        this.paSpace = new Label(paComposite, 4);
        this.paSpace.setText("                     ");
        this.paSyntax = new Label(paComposite, 4);
        this.paSyntax.setText("Comma-separated entries each of which may be =n, <n, >n, #n, \n[a:b:..:c] or left empty, e.g., =5,,>3,[2:5:8],#true,<4.17,=str");
        this.imageComposite = new Composite(this.mainComposite, 0);
        this.imageComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser = new Browser(this.imageComposite, 0);
        GridData browserLData = new GridData();
        browserLData.widthHint = 800;
        browserLData.heightHint = 200;
        this.browser.setLayoutData((Object)browserLData);
        this.browser.setText("");
        Composite ev2Composite = new Composite(this.mainComposite, 0);
        ev2Composite.setLayout((Layout)new GridLayout(8, false));
        ev2Composite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.startButton2 = new Button(ev2Composite, 8);
        this.startButton2.setText("Start");
        this.startButton2.setToolTipText("Start state");
        this.startButton2.setEnabled(false);
        this.prevButton2 = new Button(ev2Composite, 8);
        this.prevButton2.setText("Prev");
        this.prevButton2.setToolTipText("Previous state");
        this.prevButton2.setEnabled(false);
        this.nextButton2 = new Button(ev2Composite, 8);
        this.nextButton2.setText("Next");
        this.nextButton2.setToolTipText("Next state");
        this.nextButton2.setEnabled(false);
        this.endButton2 = new Button(ev2Composite, 8);
        this.endButton2.setText(" End ");
        this.endButton2.setToolTipText("End state");
        this.endButton2.setEnabled(false);
        this.canvasLabel = new Label(ev2Composite, 4);
        this.canvasLabel.setText("Canvas dimension");
        this.hcanvasText = new Text(ev2Composite, 2052);
        GridData hcd = new GridData();
        hcd.widthHint = 40;
        this.hcanvasText.setLayoutData((Object)hcd);
        this.hcanvasText.setText("1000");
        this.byLabel = new Label(ev2Composite, 4);
        this.byLabel.setText("   X    ");
        this.vcanvasText = new Text(ev2Composite, 2052);
        GridData vcd = new GridData();
        vcd.widthHint = 40;
        this.vcanvasText.setLayoutData((Object)vcd);
        this.vcanvasText.setText("600");
        this.rootScrollComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.statusLineManager.setMessage("Developed at Amrita Vishwa Vidyapeetham, India");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.browseButtonAction(e);
            }
        });
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.exportButtonAction(e);
            }
        });
        this.attributeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.keyAttributeAction(e);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.addButtonAction(e);
            }
        });
        this.drawButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.drawButtonAction(e);
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.resetButtonAction(e);
            }
        });
        this.ssChkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.ssChkBoxAction(e);
            }
        });
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.startButtonAction(e);
            }
        });
        this.prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.prevButtonAction(e);
            }
        });
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.nextButtonAction(e);
            }
        });
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.endButtonAction(e);
            }
        });
        this.startButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.startButtonAction(e);
            }
        });
        this.prevButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.prevButtonAction(e);
            }
        });
        this.nextButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.nextButtonAction(e);
            }
        });
        this.endButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMAbstractionGranularity.this.endButtonAction(e);
            }
        });
    }

    private void browseButtonAction(SelectionEvent e) {
        if (this.image != null && !this.image.isDisposed()) {
            System.out.println("Image disposedx");
            this.image.dispose();
        }
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent(), 4096));
        fd.setText("Open CSV File");
        String[] filterExtensions = new String[]{"*.csv"};
        fd.setFilterExtensions(filterExtensions);
        String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        this.fileText.setText(fileName);
        this.sd = new StateDiagram();
        this.sd.attributes = new TreeSet();
        this.sd.attributesMap = new TreeMap();
        this.sd.fwevents = new ArrayList();
        this.sd.keys = new ArrayList();
        this.sd.transitions = new LinkedHashMap();
        this.sd.allTransitions = new ArrayList();
        this.attributeList.removeAll();
        this.kvText.setText("");
        this.paText.setText("");
        this.drawButton.setEnabled(true);
        this.ssChkBox.setSelection(false);
        this.aRun.setSelection(false);
        this.sd.traceFile = fileName;
        this.sd.readEvents();
        this.sd.printAttributes();
        this.browser.setText("<html><body><p>Loaded " + fileName + "</p></body></html>");
    }

    private void exportButtonAction(SelectionEvent e) {
        IPath path = ResourcesPlugin.getPlugin().getStateLocation();
        String from = String.valueOf(path.toFile().getPath()) + File.separator + "state.svg";
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent()), 8192);
        fd.setText("Export As");
        String[] filterExtensions = new String[]{"*.svg"};
        fd.setFilterExtensions(filterExtensions);
        String to = fd.open();
        if (to == null) {
            return;
        }
        File fromFile = new File(from);
        File toFile = new File(to);
        try {
            Files.copy(fromFile.toPath(), toFile.toPath(), new CopyOption[0]);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    private void keyAttributeAction(SelectionEvent e) {
        String keyVar = this.attributeList.getText();
        System.out.println(keyVar);
        this.browser.setText("<html><body><p>Selected key attribute: " + keyVar + "</p></body></html>");
    }

    private void addButtonAction(SelectionEvent e) {
        String keyVar = this.attributeList.getText();
        if (!keyVar.equals("")) {
            if (this.kvText.getText().equals("")) {
                this.kvText.setText(keyVar);
            } else {
                this.kvText.setText(String.valueOf(this.kvText.getText()) + "," + keyVar);
            }
            System.out.println("Adding key attribute ... " + keyVar);
            this.browser.setText("<html><body><p>Attributes added : " + this.kvText.getText() + "</p></body></html>");
        }
        this.attributeList.setText("");
    }

    private void drawButtonAction(SelectionEvent e) {
        this.sd.keys = new ArrayList();
        this.sd.states = new ArrayList();
        this.sd.paStates = new ArrayList();
        this.sd.transitions = new LinkedHashMap();
        if (this.kvText.getText().equals("")) {
            return;
        }
        this.sd.readKeyAttributes();
        this.sd.createStates();
        if (this.granularity[1].getSelection()) {
            this.sd.methodConsolidation();
        }
        this.sd.abstraction();
        if (this.aRun.getSelection()) {
            this.sd.generateSVG(this.sd.exportRun(Integer.MAX_VALUE));
        } else {
            this.sd.createTransitions(Integer.MAX_VALUE);
            if (this.transitionCount.getSelection()) {
                this.sd.generateSVG(this.sd.exportToPlantUML(true));
            } else {
                this.sd.generateSVG(this.sd.exportToPlantUML(false));
            }
        }
    }

    private void resetButtonAction(SelectionEvent e) {
        this.kvText.setText("");
        this.paText.setText("");
        this.browser.setText("<html><body><p>Attributes reset</p></body></html>");
    }

    private void ssChkBoxAction(SelectionEvent e) {
        if (this.ssChkBox.getSelection()) {
            this.drawButton.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.prevButton2.setEnabled(false);
            this.startButton.setEnabled(true);
            this.startButton2.setEnabled(true);
        } else {
            this.drawButton.setEnabled(true);
            this.startButton.setEnabled(false);
            this.startButton2.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.prevButton2.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.nextButton2.setEnabled(false);
            this.endButton.setEnabled(false);
            this.endButton2.setEnabled(false);
        }
    }

    private void startButtonAction(SelectionEvent e) {
        this.sd.keys = new ArrayList();
        this.sd.states = new ArrayList();
        this.sd.paStates = new ArrayList();
        this.sd.transitions = new LinkedHashMap();
        this.sd.allTransitions = new ArrayList();
        this.sd.readKeyAttributes();
        this.sd.printKeyAttributes();
        this.sd.createStates();
        if (this.granularity[1].getSelection()) {
            this.sd.methodConsolidation();
        }
        this.sd.abstraction();
        this.count = 0;
        if (this.aRun.getSelection()) {
            this.sd.generateSVG(this.sd.exportRun(this.count));
        } else {
            this.sd.createTransitions(this.count);
            if (this.transitionCount.getSelection()) {
                this.sd.generateSVG(this.sd.exportToPlantUML(true));
            } else {
                this.sd.generateSVG(this.sd.exportToPlantUML(false));
            }
        }
        this.prevButton.setEnabled(false);
        this.prevButton2.setEnabled(false);
        this.nextButton.setEnabled(true);
        this.nextButton2.setEnabled(true);
        this.endButton.setEnabled(true);
        this.endButton2.setEnabled(true);
    }

    private void prevButtonAction(SelectionEvent e) {
        if (this.count > 0) {
            this.nextButton.setEnabled(true);
            this.nextButton2.setEnabled(true);
        }
        if (this.aRun.getSelection()) {
            this.sd.generateSVG(this.sd.exportRun(--this.count));
        } else {
            this.sd.createTransitions(--this.count);
            if (this.transitionCount.getSelection()) {
                this.sd.generateSVG(this.sd.exportToPlantUML(true));
            } else {
                this.sd.generateSVG(this.sd.exportToPlantUML(false));
            }
        }
        if (this.count <= 0) {
            this.prevButton.setEnabled(false);
            this.prevButton2.setEnabled(false);
        }
    }

    private void nextButtonAction(SelectionEvent e) {
        if (this.count < this.sd.paStates.size() - 1) {
            this.prevButton.setEnabled(true);
            this.prevButton2.setEnabled(true);
        }
        if (this.aRun.getSelection()) {
            this.sd.generateSVG(this.sd.exportRun(++this.count));
        } else {
            this.sd.createTransitions(++this.count);
            if (this.transitionCount.getSelection()) {
                this.sd.generateSVG(this.sd.exportToPlantUML(true));
            } else {
                this.sd.generateSVG(this.sd.exportToPlantUML(false));
            }
        }
        if (this.count >= this.sd.paStates.size() - 1) {
            this.nextButton.setEnabled(false);
            this.nextButton2.setEnabled(false);
        }
    }

    private void endButtonAction(SelectionEvent e) {
        this.count = this.sd.paStates.size() - 1;
        if (this.aRun.getSelection()) {
            this.sd.generateSVG(this.sd.exportRun(Integer.MAX_VALUE));
        } else {
            this.sd.createTransitions(Integer.MAX_VALUE);
            if (this.transitionCount.getSelection()) {
                this.sd.generateSVG(this.sd.exportToPlantUML(true));
            } else {
                this.sd.generateSVG(this.sd.exportToPlantUML(false));
            }
        }
        this.prevButton.setEnabled(true);
        this.prevButton2.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.nextButton2.setEnabled(false);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Finite State Machine", (String)message);
    }

    public void setFocus() {
    }

    class FWEvent {
        public String thread;
        public String object;
        public String field;
        public String value;
        public String method;

        FWEvent(String t, String o, String f, String v, String m) {
            this.thread = t;
            this.object = o;
            this.field = f;
            this.value = v;
            this.method = m;
        }

        public String toString() {
            return String.valueOf(this.object) + "->" + this.field + "=" + this.value + "   (" + this.method + "," + this.thread + ")";
        }

        public String getThread() {
            return this.thread;
        }

        public String getObject() {
            return this.object;
        }

        public String getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getMethod() {
            return this.method;
        }
    }

    class KeyAttribute {
        public String object;
        public String field;

        KeyAttribute(String o, String f) {
            this.object = o;
            this.field = f;
        }

        public String toString() {
            return String.valueOf(this.object) + "->" + this.field;
        }

        public String getObject() {
            return this.object;
        }

        public String getField() {
            return this.field;
        }
    }

    class State {
        ArrayList<String> keyVar = new ArrayList();
        String method = null;
        boolean hashed = false;
        int time = 0;

        State() {
        }

        public int getSize() {
            return this.keyVar.size();
        }

        public void set(int index, String value) {
            this.keyVar.add(index, value);
        }

        public String get(int index) {
            return this.keyVar.get(index);
        }

        public void setMethod(String m) {
            this.method = m;
        }

        public String getMethod() {
            return this.method;
        }

        public void remove(int index) {
            this.keyVar.remove(index);
        }

        public void copy(State s) {
            int j = 0;
            while (j < s.getSize()) {
                this.keyVar.add(j, s.get(j));
                ++j;
            }
            if (s.method != null) {
                this.method = new String(s.method);
            }
            this.time = s.time;
        }

        public String toString() {
            StringBuffer sbKeys = new StringBuffer();
            sbKeys.append(this.keyVar.get(0));
            int j = 1;
            while (j < this.keyVar.size()) {
                sbKeys.append(",");
                sbKeys.append(this.keyVar.get(j));
                ++j;
            }
            return sbKeys.toString();
        }

        public void print(int flag) {
            if (flag == 0) {
                System.out.println(this.toString());
            } else if (flag == 1) {
                System.out.println(String.valueOf(this.toString()) + " (" + this.method + ") " + this.hashed + " time=" + this.time);
            }
        }
    }

    class StateDiagram {
        private String traceFile;
        private TreeSet<String> attributes;
        private TreeMap<String, Integer> attributesMap;
        private ArrayList<FWEvent> fwevents;
        private ArrayList<KeyAttribute> keys;
        ArrayList<State> states = new ArrayList();
        ArrayList<State> paStates = new ArrayList();
        private LinkedHashMap<String, Integer> transitions;
        private ArrayList<String> allTransitions;

        StateDiagram() {
        }

        public void readEvents() {
            ArrayList<String> sortedAttributes = new ArrayList<String>();
            HashMap<String, Stack> callStacks = new HashMap<String, Stack>();
            String lastMethod = null;
            String strLine = null;
            try {
                Scanner sc = new Scanner(new File(this.traceFile));
                int counter = 0;
                while (sc.hasNext()) {
                    Stack threadStack;
                    String thrd;
                    strLine = sc.nextLine().trim();
                    if (strLine.contains("Method Call")) {
                        thrd = strLine.substring(0, strLine.indexOf(44)).replace("\"", "").trim();
                        lastMethod = strLine.substring(strLine.indexOf("target=") + 7);
                        lastMethod = lastMethod.substring(lastMethod.indexOf(35) + 1).replace("\"", "").trim();
                        lastMethod = String.valueOf(lastMethod) + ":" + counter++;
                        if (callStacks.containsKey(thrd)) {
                            threadStack = (Stack)callStacks.get(thrd);
                            threadStack.push(lastMethod);
                            callStacks.put(thrd, threadStack);
                        } else {
                            threadStack = new Stack();
                            threadStack.push(lastMethod);
                            callStacks.put(thrd, threadStack);
                        }
                    }
                    if (strLine.contains("Field Write")) {
                        String[] tokens = strLine.split(",");
                        String thread = tokens[0].replace("\"", "").trim();
                        String object = tokens[4].substring(tokens[4].indexOf("=") + 1).replace("\"", "").trim();
                        String field = tokens[5].substring(0, tokens[5].indexOf("=")).replace("\"", "").trim();
                        String value = tokens[5].substring(tokens[5].indexOf("=") + 1).replace("\"", "").trim();
                        if (value.equals("")) {
                            value = " ";
                        }
                        if (value.equals("start")) {
                            value = "_start";
                        }
                        String entry = String.valueOf(object) + "->" + field;
                        this.fwevents.add(new FWEvent(thread, object, field, value, lastMethod));
                        if (!this.attributes.contains(entry)) {
                            this.attributes.add(entry);
                            this.attributesMap.put(entry, 1);
                            if (Integer.parseInt(FSMAbstractionGranularity.this.repeatText.getText()) == 1) {
                                sortedAttributes.add(entry);
                            }
                        } else {
                            int count = this.attributesMap.get(entry);
                            this.attributesMap.put(entry, ++count);
                            if (count == Integer.parseInt(FSMAbstractionGranularity.this.repeatText.getText())) {
                                sortedAttributes.add(entry);
                            }
                        }
                    }
                    if (!strLine.contains("Method Returned")) continue;
                    thrd = strLine.substring(0, strLine.indexOf(44));
                    threadStack = (Stack)callStacks.get(thrd);
                    callStacks.put(thrd, threadStack);
                }
                sc.close();
                sortedAttributes.sort(null);
                int i = 0;
                while (i < sortedAttributes.size()) {
                    FSMAbstractionGranularity.this.attributeList.add((String)sortedAttributes.get(i));
                    ++i;
                }
                FSMAbstractionGranularity.this.granularity[1].setEnabled(true);
                FSMAbstractionGranularity.this.granularity[0].setSelection(true);
                int e = 1;
                while (e < this.fwevents.size()) {
                    if (this.fwevents.get(e).getMethod() == null) {
                        FSMAbstractionGranularity.this.granularity[1].setEnabled(false);
                        FSMAbstractionGranularity.this.granularity[0].setSelection(true);
                        break;
                    }
                    ++e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void printAttributes() {
            Iterator<String> it = this.attributes.iterator();
            while (it.hasNext()) {
                System.out.println((Object)it.next());
            }
        }

        public void readKeyAttributes() {
            String userChoices = "";
            userChoices = FSMAbstractionGranularity.this.kvText.getText();
            if (userChoices.equals("")) {
                return;
            }
            String[] uc = userChoices.split(",");
            int i = 0;
            while (i < uc.length) {
                if (this.attributes.contains(uc[i])) {
                    String[] of = uc[i].split("->");
                    this.keys.add(new KeyAttribute(of[0], of[1]));
                }
                ++i;
            }
            this.printKeyAttributes();
        }

        public void printKeyAttributes() {
            Iterator<KeyAttribute> it = this.keys.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }

        public void createStates() {
            int time = 0;
            State currentState = new State();
            int s = 0;
            while (s < this.keys.size()) {
                currentState.set(s, "null");
                ++s;
            }
            currentState.method = "init";
            currentState.time = time;
            this.states.add(currentState);
            State nextState = new State();
            nextState.copy(currentState);
            int i = 0;
            while (i < this.fwevents.size()) {
                int j = 0;
                while (j < this.keys.size()) {
                    if (this.fwevents.get(i).getObject().equals(this.keys.get(j).getObject()) && this.fwevents.get(i).getField().equals(this.keys.get(j).getField())) {
                        nextState.remove(j);
                        nextState.set(j, this.fwevents.get(i).getValue());
                        nextState.setMethod(this.fwevents.get(i).getMethod());
                        nextState.time = ++time;
                        State st = new State();
                        st.copy(nextState);
                        this.states.add(st);
                    }
                    ++j;
                }
                currentState = new State();
                currentState.copy(nextState);
                ++i;
            }
            this.printStates();
        }

        public void printStates() {
            int s = 0;
            while (s < this.states.size()) {
                this.states.get(s).print(1);
                ++s;
            }
        }

        public void methodConsolidation() {
            int s = 0;
            while (s < this.states.size() - 1) {
                if (this.states.get(s).getMethod().equals(this.states.get(s + 1).getMethod())) {
                    this.states.remove(s);
                    continue;
                }
                ++s;
            }
            this.printStates();
        }

        public void abstraction() {
            this.paStates = new ArrayList();
            int s = 0;
            while (s < this.states.size()) {
                State paState = new State();
                paState.copy(this.states.get(s));
                this.paStates.add(paState);
                ++s;
            }
            String paStr = FSMAbstractionGranularity.this.paText.getText().trim();
            if (paStr.equals("")) {
                return;
            }
            String[] paEntries = paStr.split(",");
            boolean reductionFlag = false;
            int s2 = 0;
            while (s2 < this.paStates.size()) {
                int k = 0;
                while (k < paEntries.length && k < this.paStates.get((int)s2).keyVar.size()) {
                    if (!paEntries[k].trim().equals("")) {
                        String absVal = this.applyAbstraction(this.paStates.get((int)s2).keyVar.get(k), paEntries[k]);
                        if (absVal.equals("")) {
                            reductionFlag = true;
                            break;
                        }
                        this.paStates.get((int)s2).keyVar.set(k, absVal);
                    }
                    ++k;
                }
                if (reductionFlag) {
                    State hState = new State();
                    hState.copy(this.paStates.get(s2));
                    hState.hashed = true;
                    this.paStates.set(s2, hState);
                    reductionFlag = false;
                    ++s2;
                    continue;
                }
                ++s2;
            }
            this.printPaStates();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String applyAbstraction(String value, String predicate) {
            if (value.equals("null")) {
                return value;
            }
            char lhs = predicate.trim().charAt(0);
            if (lhs != '=' && lhs != '>' && lhs != '<' && lhs != '[' && lhs != '#' && lhs != '~') {
                return value;
            }
            String rhs = predicate.trim().substring(1).trim();
            int choice = lhs == '#' ? 4 : (rhs.matches("^[0-9]+$") ? 0 : (rhs.matches("^[0-9]+.[0-9]+$") ? 1 : (rhs.endsWith("]") ? 2 : 3)));
            switch (choice) {
                case 0: {
                    int n = Integer.parseInt(predicate.substring(1).trim());
                    if (predicate.trim().startsWith("<")) {
                        if (Integer.parseInt(value) >= n) return ">=" + n;
                        return "<" + n;
                    }
                    if (predicate.trim().startsWith(">")) {
                        if (Integer.parseInt(value) <= n) return "<=" + n;
                        return ">" + n;
                    }
                    if (predicate.trim().startsWith("=")) {
                        if (Integer.parseInt(value) != n) return "~" + n;
                        return "" + n;
                    }
                    if (!predicate.trim().startsWith("~")) return value;
                    if (Integer.parseInt(value) == n) return "" + n;
                    return "~" + n;
                }
                case 1: {
                    double d = Double.parseDouble(predicate.substring(1).trim());
                    if (predicate.trim().startsWith("<")) {
                        if (!(Double.parseDouble(value) < d)) return ">=" + d;
                        return "<" + d;
                    }
                    if (predicate.trim().startsWith(">")) {
                        if (!(Double.parseDouble(value) > d)) return "<=" + d;
                        return ">" + d;
                    }
                    if (predicate.trim().startsWith("=")) {
                        if (Double.parseDouble(value) != d) return "~" + d;
                        return "" + d;
                    }
                    if (!predicate.trim().startsWith("~")) return value;
                    if (Double.parseDouble(value) == d) return "" + d;
                    return "~" + d;
                }
                case 2: {
                    String[] range = predicate.substring(1, predicate.indexOf(93)).split(":");
                    try {
                        if (Integer.parseInt(value) < Integer.parseInt(range[0])) {
                            return "<" + Integer.parseInt(range[0]);
                        }
                        int i = 0;
                        while (i < range.length - 1) {
                            if (Integer.parseInt(value) >= Integer.parseInt(range[i]) && Integer.parseInt(value) < Integer.parseInt(range[i + 1])) {
                                return String.valueOf(Integer.parseInt(range[i])) + ":" + Integer.parseInt(range[i + 1]);
                            }
                            ++i;
                        }
                        if (Integer.parseInt(value) < Integer.parseInt(range[range.length - 1])) return value;
                        return ">=" + Integer.parseInt(range[range.length - 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return value;
                    }
                }
                case 3: {
                    String s = predicate.substring(1).trim();
                    if (predicate.trim().startsWith("=")) {
                        if (!value.equals(s)) return "~" + s;
                        return s;
                    }
                    if (predicate.trim().startsWith("~")) {
                        if (value.equals(s)) return s;
                        return "~" + s;
                    }
                }
                case 4: {
                    String ss = predicate.substring(1).trim();
                    if (!predicate.trim().startsWith("#") || !value.equals(ss)) return "";
                    return ss;
                }
            }
            return value;
        }

        public void printPaStates() {
            this.paStates.forEach(k -> k.print(1));
        }

        public void createTransitions(int count) {
            this.transitions = new LinkedHashMap();
            String transition = "(*) --> \"" + this.paStates.get(0).toString() + "\"";
            this.transitions.put(transition, 1);
            int s = 0;
            String lastTransition = "";
            while (s < count && s < this.paStates.size() - 1) {
                if (!(this.paStates.get((int)s).hashed && this.paStates.get((int)(s + 1)).hashed || !this.paStates.get((int)s).hashed && this.paStates.get((int)(s + 1)).hashed)) {
                    if (this.paStates.get((int)s).hashed && !this.paStates.get((int)(s + 1)).hashed) {
                        transition = new String("\"" + this.paStates.get(s + 1).toString() + "\"" + " -[#white]-> " + "\"" + this.paStates.get(s + 1).toString() + "\"");
                        this.transitions.merge(transition, 1, Integer::sum);
                    } else {
                        transition = new String("\"" + this.paStates.get(s).toString() + "\"" + " --> " + "\"" + this.paStates.get(s + 1).toString() + "\"");
                        this.transitions.merge(transition, 1, Integer::sum);
                        lastTransition = new String(transition);
                    }
                }
                ++s;
            }
            if (s >= 1 && this.transitions.containsKey(lastTransition)) {
                int value = this.transitions.get(lastTransition);
                this.transitions.remove(lastTransition);
                this.transitions.put(String.valueOf(lastTransition) + " #red", value);
            }
            FSMAbstractionGranularity.this.sd.printTransitions();
        }

        public void printTransitions() {
            this.transitions.forEach((k, v) -> System.out.println(k.replaceAll("-->", "--> [" + v + "]")));
        }

        public String exportToPlantUML(boolean transitionCount) {
            FSMAbstractionGranularity.this.sb = new StringBuffer();
            FSMAbstractionGranularity.this.sb.append("@startuml\n");
            if (transitionCount) {
                this.transitions.forEach((k, v) -> {
                    StringBuffer stringBuffer = FSMAbstractionGranularity.this.sb.append(String.valueOf(k.replaceAll("-->", "--> [" + v + "]")) + "\n");
                });
            } else {
                this.transitions.forEach((k, v) -> {
                    StringBuffer stringBuffer = FSMAbstractionGranularity.this.sb.append(String.valueOf(k) + "\n");
                });
            }
            FSMAbstractionGranularity.this.sb.append("@enduml\n");
            return FSMAbstractionGranularity.this.sb.toString();
        }

        public String exportRun(int count) {
            String[] direction = new String[]{"right", "right", "right", "right", "right", "right", "right", "right", "down", "left", "left", "left", "left", "left", "left", "left", "left", "down"};
            StringBuffer runsb = new StringBuffer();
            runsb.append("@startuml\n");
            runsb.append("(*) -right-> \"t=" + this.paStates.get((int)0).time + "\\n" + this.paStates.get(0).toString() + "\"" + "\n");
            int s = 0;
            while (s < count && s < this.paStates.size() - 1) {
                runsb.append("\"t=" + this.paStates.get((int)s).time + "\\n" + this.paStates.get(s).toString() + "\"" + " -" + direction[s % 18] + "-> " + "\"t=" + this.paStates.get((int)(s + 1)).time + "\\n" + this.paStates.get(s + 1).toString() + "\"" + "\n");
                ++s;
            }
            runsb.append("@enduml\n");
            return runsb.toString();
        }

        public void generateSVG(String source) {
            IPath path = ResourcesPlugin.getPlugin().getStateLocation();
            System.out.println(path);
            SourceStringReader reader = new SourceStringReader(source);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(String.valueOf(path.toFile().getPath()) + File.separator + "state.svg");
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(fnfe);
            }
            try {
                reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
                reader.generateImage((OutputStream)fos, new FileFormatOption(FileFormat.SVG));
                os.close();
                ((OutputStream)fos).close();
            }
            catch (IOException iOException) {
                System.out.println("Unable to generate SVG");
            }
            FSMAbstractionGranularity.this.svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
            GridData browserLData = new GridData();
            browserLData.widthHint = Integer.parseInt(FSMAbstractionGranularity.this.hcanvasText.getText());
            browserLData.heightHint = Integer.parseInt(FSMAbstractionGranularity.this.vcanvasText.getText());
            FSMAbstractionGranularity.this.browser.setLayoutData((Object)browserLData);
            FSMAbstractionGranularity.this.browser.setText(FSMAbstractionGranularity.this.svg);
            FSMAbstractionGranularity.this.imageComposite.pack();
            FSMAbstractionGranularity.this.rootScrollComposite.setMinSize(FSMAbstractionGranularity.this.mainComposite.computeSize(-1, -1));
        }
    }

    class Transition {
        String current;
        String next;
        String method;
        int count;

        Transition(String c, String n, String m) {
            this.current = c;
            this.next = n;
            this.method = m;
            this.count = 1;
        }

        public String toString() {
            return "\"" + this.current + "\"" + " --> " + "[" + this.count + "]" + "\"" + this.next + "\"";
        }
    }
}

