/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.views;

import edu.buffalo.cse.jive.finiteStateMachine.models.Event;
import edu.buffalo.cse.jive.finiteStateMachine.models.InputFileParser;
import edu.buffalo.cse.jive.finiteStateMachine.models.TransitionBuilder;
import edu.buffalo.cse.jive.finiteStateMachine.monitor.Monitor;
import edu.buffalo.cse.jive.finiteStateMachine.monitor.OfflineMonitor;
import edu.buffalo.cse.jive.finiteStateMachine.parser.TopDownParser;
import edu.buffalo.cse.jive.finiteStateMachine.parser.expression.expression.Expression;
import edu.buffalo.cse.jive.finiteStateMachine.util.TemporaryDataTransporter;
import edu.buffalo.cse.jive.finiteStateMachine.views.SvgGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class FSMPropertyChecker
extends ViewPart {
    public static final String ID = "edu.buffalo.cse.jive.finiteStateMachine.views.FiniteStateMachine";
    private IStatusLineManager statusLineManager;
    private Display display;
    private ScrolledComposite rootScrollComposite;
    private Composite mainComposite;
    private Label fileLabel;
    private Text fileText;
    private Combo attributeList;
    private Button browseButton;
    private Button validateButton;
    private Button exportButton;
    private Composite imageComposite;
    private Image image;
    public boolean horizontal;
    public boolean vertical;
    private Label kvLabel;
    private Text kvText;
    private Label paLabel;
    private Text paText;
    private Button addButton;
    private Button resetButton;
    private Button drawButton;
    private Label kvSyntax;
    private Label kvSpace;
    private Browser browser;
    private Label canvasLabel;
    private Label byLabel;
    private Label statusLabel;
    private Text hcanvasText;
    private Text vcanvasText;
    private Label propertyLabel;
    private Text propertyText;
    private BlockingQueue<Event> incomingEvents;
    private SvgGenerator svgGenerator;
    private TransitionBuilder transitionBuilder;
    private Label errorText;
    private Monitor monitor;
    private Button[] granularity;
    private Label grLabel;

    public void createPartControl(Composite parent) {
        this.statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.display = parent.getDisplay();
        GridLayout layoutParent = new GridLayout();
        layoutParent.numColumns = 1;
        parent.setLayout((Layout)layoutParent);
        this.rootScrollComposite = new ScrolledComposite(parent, 768);
        this.rootScrollComposite.setLayout((Layout)new GridLayout(1, false));
        this.rootScrollComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rootScrollComposite.setExpandHorizontal(true);
        this.rootScrollComposite.setExpandVertical(true);
        this.mainComposite = new Composite((Composite)this.rootScrollComposite, 0);
        this.rootScrollComposite.setContent((Control)this.mainComposite);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite browseComposite = new Composite(this.mainComposite, 0);
        browseComposite.setLayout((Layout)new GridLayout(5, false));
        browseComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.browseButton = new Button(browseComposite, 8);
        this.browseButton.setText("Browse");
        this.fileLabel = new Label(browseComposite, 4);
        this.fileLabel.setText("CSV File : ");
        this.fileText = new Text(browseComposite, 8);
        this.fileText.setBackground(Display.getCurrent().getSystemColor(15));
        GridData gd = new GridData();
        gd.widthHint = 550;
        this.fileText.setLayoutData((Object)gd);
        Composite kvComposite = new Composite(this.mainComposite, 0);
        kvComposite.setLayout((Layout)new GridLayout(2, false));
        kvComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.kvLabel = new Label(kvComposite, 4);
        this.kvLabel.setText("Key Attributes");
        this.kvText = new Text(kvComposite, 2052);
        GridData gd5 = new GridData();
        gd5.widthHint = 650;
        this.kvText.setLayoutData((Object)gd5);
        this.kvSpace = new Label(kvComposite, 4);
        this.kvSpace.setText("                     ");
        this.kvSyntax = new Label(kvComposite, 4);
        this.kvSyntax.setText("   class:index->field,......,class:index->field");
        Composite evComposite = new Composite(this.mainComposite, 0);
        evComposite.setLayout((Layout)new GridLayout(10, false));
        evComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.attributeList = new Combo(evComposite, 2052);
        this.addButton = new Button(evComposite, 8);
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Adds the key attribute selected");
        this.drawButton = new Button(evComposite, 8);
        this.drawButton.setText("Draw");
        this.drawButton.setToolTipText("Draws the state diagram");
        this.validateButton = new Button(evComposite, 8);
        this.validateButton.setText("Validate");
        this.validateButton.setToolTipText("Validates and draws the state diagram");
        this.resetButton = new Button(evComposite, 8);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("Clears the key attributes");
        this.exportButton = new Button(evComposite, 8);
        this.exportButton.setText("Export");
        this.exportButton.setToolTipText("Exports the state diagram");
        Composite grComposite = new Composite(this.mainComposite, 0);
        grComposite.setLayout((Layout)new GridLayout(10, false));
        grComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.grLabel = new Label(grComposite, 4);
        this.grLabel.setText("Granularity");
        this.granularity = new Button[2];
        this.granularity[0] = new Button(grComposite, 16);
        this.granularity[0].setSelection(true);
        this.granularity[0].setText("Field");
        this.granularity[1] = new Button(grComposite, 16);
        this.granularity[1].setSelection(false);
        this.granularity[1].setText("Method");
        Composite paComposite = new Composite(this.mainComposite, 0);
        paComposite.setLayout((Layout)new GridLayout(2, false));
        paComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.paLabel = new Label(paComposite, 4);
        this.paLabel.setText("Abbreviations");
        this.paText = new Text(paComposite, 2052);
        GridData gd5b = new GridData();
        gd5b.widthHint = 400;
        this.paText.setLayoutData((Object)gd5b);
        Composite grammarView = new Composite(this.mainComposite, 0);
        grammarView.setLayout((Layout)new GridLayout(3, false));
        grammarView.setLayoutData((Object)new GridData(4, 4, false, false));
        this.propertyLabel = new Label(grammarView, 4);
        this.propertyLabel.setText("Properties       ");
        this.propertyText = new Text(grammarView, 512);
        GridData grid = new GridData();
        grid.widthHint = 400;
        grid.heightHint = 100;
        this.propertyText.setLayoutData((Object)grid);
        Composite errorComposite = new Composite(this.mainComposite, 0);
        errorComposite.setLayout((Layout)new GridLayout(1, false));
        this.errorText = new Label(errorComposite, 0);
        this.errorText.setText("                                                                ");
        this.imageComposite = new Composite(this.mainComposite, 0);
        this.imageComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser = new Browser(this.imageComposite, 0);
        Composite ev2Composite = new Composite(this.mainComposite, 0);
        ev2Composite.setLayout((Layout)new GridLayout(8, false));
        ev2Composite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.canvasLabel = new Label(ev2Composite, 4);
        this.canvasLabel.setText("Canvas dimension");
        this.hcanvasText = new Text(ev2Composite, 2052);
        GridData hcd = new GridData();
        hcd.widthHint = 40;
        this.hcanvasText.setLayoutData((Object)hcd);
        this.hcanvasText.setText("1000");
        this.byLabel = new Label(ev2Composite, 4);
        this.byLabel.setText("   X    ");
        this.vcanvasText = new Text(ev2Composite, 2052);
        GridData vcd = new GridData();
        vcd.widthHint = 40;
        this.vcanvasText.setLayoutData((Object)vcd);
        this.vcanvasText.setText("600");
        this.statusLabel = new Label(ev2Composite, 4);
        this.statusLabel.setText("StatusUpdate:");
        this.svgGenerator = new SvgGenerator(this.hcanvasText, this.vcanvasText, this.browser, this.imageComposite, this.rootScrollComposite, this.mainComposite, this.display);
        this.addButton.setEnabled(false);
        this.drawButton.setEnabled(false);
        this.validateButton.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.validateButtonAction(e);
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.browseButtonAction(e);
            }
        });
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.exportButtonAction(e);
            }
        });
        this.attributeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.keyAttributeAction(e);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.addButtonAction(e);
            }
        });
        this.drawButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.drawButtonAction(e);
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMPropertyChecker.this.resetButtonAction(e);
            }
        });
    }

    private Set<String> readKeyAttributes(Text attributes, Text abbreviations) {
        if (attributes != null && attributes.getText().length() > 0) {
            LinkedHashSet<String> keyAttributes = new LinkedHashSet<String>();
            String selected = attributes.getText();
            String[] stringArray = selected.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                keyAttributes.add(attribute.trim());
                ++n2;
            }
            if (abbreviations != null && abbreviations.getText().length() > 0) {
                Event.abbreviations.clear();
                String[] tokens = abbreviations.getText().split(",");
                if (tokens == null || tokens.length == 0) {
                    throw new IllegalArgumentException("Invalid Abbreviations");
                }
                String[] stringArray2 = tokens;
                int n3 = tokens.length;
                n = 0;
                while (n < n3) {
                    String abbreviation = stringArray2[n];
                    String[] tks = abbreviation.split("=");
                    if (tks == null || tks.length != 2) {
                        throw new IllegalArgumentException("Invalid Abbreviations");
                    }
                    String attribute = tks[0].trim();
                    if (!keyAttributes.contains(attribute)) {
                        throw new IllegalArgumentException("Invalid Abbreviations");
                    }
                    Event.abbreviations.put(attribute, tks[1].trim());
                    ++n;
                }
            }
            return keyAttributes;
        }
        throw new IllegalArgumentException("Please add atleast one attribute");
    }

    private List<Expression> parseExpressions(Text propertyText) throws Exception {
        if (propertyText != null && propertyText.getText().length() > 0) {
            TopDownParser parser = new TopDownParser();
            String properties = propertyText.getText().trim();
            return parser.parse(properties.split(";"));
        }
        throw new IllegalArgumentException("Please enter properties to validate");
    }

    private void validateButtonAction(SelectionEvent e) {
        this.errorText.setText("                                                                ");
        try {
            TemporaryDataTransporter.shouldHighlight = false;
            Set<String> keyAttributes = this.readKeyAttributes(this.kvText, this.paText);
            List<Expression> expressions = null;
            try {
                expressions = this.parseExpressions(this.propertyText);
            }
            catch (Exception e3) {
                this.errorText.setText(e3.getMessage());
                e3.printStackTrace();
            }
            if (expressions != null && expressions.size() > 0) {
                this.monitor = new OfflineMonitor(keyAttributes, this.incomingEvents, this.granularity[1].getSelection());
                this.monitor.run();
                if (this.monitor.validate(expressions)) {
                    this.errorText.setText("All properties satisfied.                                 ");
                }
                this.transitionBuilder = new TransitionBuilder(this.monitor.getRootState(), this.monitor.getStates());
                this.transitionBuilder.build();
                this.svgGenerator.generate(this.transitionBuilder.getTransitions());
                this.exportButton.setEnabled(true);
            }
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            this.errorText.setText(e1.getMessage());
        }
        catch (ClassCastException e2) {
            this.errorText.setText("Type mismatch in properties");
            e2.printStackTrace();
        }
        catch (Exception e2) {
            this.errorText.setText("Unexpected error parsing properties");
            e2.printStackTrace();
        }
    }

    private void browseButtonAction(SelectionEvent e) {
        if (this.image != null && !this.image.isDisposed()) {
            System.out.println("Image disposedx");
            this.image.dispose();
        }
        this.statusLineManager.setMessage(null);
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent(), 4096));
        fd.setText("Open CSV File");
        String[] filterExtensions = new String[]{"*.csv"};
        fd.setFilterExtensions(filterExtensions);
        String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        this.fileText.setText(fileName);
        this.attributeList.removeAll();
        this.kvText.setText("");
        this.paText.setText("");
        this.propertyText.setText("");
        this.errorText.setText("                                                                ");
        this.monitor = null;
        InputFileParser inputFileParser = new InputFileParser(fileName);
        Set<String> allAttributes = inputFileParser.getAllFields();
        this.incomingEvents = inputFileParser.getEvents();
        for (String attribute : allAttributes) {
            this.attributeList.add(attribute);
        }
        this.addButton.setEnabled(true);
        this.drawButton.setEnabled(true);
        this.validateButton.setEnabled(true);
        this.statusLineManager.setMessage("Loaded " + fileName);
    }

    private void exportButtonAction(SelectionEvent e) {
        SourceStringReader reader = new SourceStringReader(this.transitionBuilder.getTransitions());
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent()), 8192);
        fd.setText("Export As");
        String[] filterExtensions = new String[]{"*.svg"};
        fd.setFilterExtensions(filterExtensions);
        String fileName = fd.open();
        if (fileName != null) {
            try {
                reader.outputImage(new File(fd.open()));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void keyAttributeAction(SelectionEvent e) {
        String keyVar = this.attributeList.getText();
        System.out.println(keyVar);
        this.statusLineManager.setMessage("Selected key attribute: " + keyVar);
    }

    private void addButtonAction(SelectionEvent e) {
        String keyVar = this.attributeList.getText();
        if (!keyVar.equals("")) {
            if (this.kvText.getText().equals("")) {
                this.kvText.setText(keyVar);
            } else {
                this.kvText.setText(String.valueOf(this.kvText.getText()) + "," + keyVar);
            }
            System.out.println("Adding key attribute ... " + keyVar);
        }
        this.attributeList.setText("");
    }

    private void drawButtonAction(SelectionEvent e) {
        this.errorText.setText("                                                                ");
        try {
            Set<String> keyAttributes = this.readKeyAttributes(this.kvText, this.paText);
            this.monitor = new OfflineMonitor(keyAttributes, this.incomingEvents, this.granularity[1].getSelection());
            this.monitor.run();
            this.transitionBuilder = new TransitionBuilder(this.monitor.getRootState(), this.monitor.getStates());
            this.transitionBuilder.build();
            this.svgGenerator.generate(this.transitionBuilder.getTransitions());
            this.statusLineManager.setMessage("Finite State Model for " + this.kvText.getText());
            this.exportButton.setEnabled(true);
        }
        catch (IllegalArgumentException e1) {
            this.errorText.setText(e1.getMessage());
        }
    }

    private void resetButtonAction(SelectionEvent e) {
        this.kvText.setText("");
        this.paText.setText("");
        this.propertyText.setText("");
        this.errorText.setText("                                                                ");
    }

    public void setFocus() {
    }
}

