/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.jive.finiteStateMachine.views;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class SvgGenerator {
    private Browser browser;
    private Composite imageComposite;
    private ScrolledComposite rootScrollComposite;
    private Composite mainComposite;
    private Display display;
    private Text hcanvasText;
    private Text vcanvasText;

    public SvgGenerator(Text hcanvasText, Text vcanvasText, Browser browser, Composite imageComposite, ScrolledComposite rootScrollComposite, Composite mainComposite, Display display) {
        this.browser = browser;
        this.imageComposite = imageComposite;
        this.rootScrollComposite = rootScrollComposite;
        this.mainComposite = mainComposite;
        this.display = display;
        this.hcanvasText = hcanvasText;
        this.vcanvasText = vcanvasText;
    }

    public void generate(String source) {
        SourceStringReader reader = new SourceStringReader(source);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
            os.close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to generate SVG");
        }
        final String svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
        final GridData browserLData = new GridData();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                browserLData.widthHint = Integer.parseInt(SvgGenerator.this.hcanvasText.getText());
                browserLData.heightHint = Integer.parseInt(SvgGenerator.this.vcanvasText.getText());
                SvgGenerator.this.browser.setLayoutData((Object)browserLData);
                SvgGenerator.this.browser.setText(svg);
                SvgGenerator.this.imageComposite.pack();
                SvgGenerator.this.rootScrollComposite.setMinSize(SvgGenerator.this.mainComposite.computeSize(-1, -1));
            }
        });
    }
}

