/*****************************/
/* Created by Dennis Brylow  */
/* Modified by Daekeun You   */
/*****************************/

#include <console-font.h>
#include <kernel.h>
#include <framebuffer.h>

/* fbControl()
 * Implements various control functions specific to a
 * framebuffer device.
 * Parameters:
 *            int dev    Standard first arg for driver interface.
 *                       In this case, always 0 for framebuffer.
 *            int func   Desired control function.  See framebuffer.h.
 *            void *arg1 Arg1 and arg2 are used to pass values in or
 *            void *arg2  out of the control function.
 * Returns:
 *            OK on success, SYSERR on failure.
 */
devcall fbControl(int dev, int func, void *arg1, void *arg2)
{
  // TODO: Implement all of these control functions.
  // set/get forgruond and background colors.
  // set/get cursor_row and cursor_col.

  switch (func)
    {
    case SETCOLOR: return OK;

    case GETCOLOR: return OK;

    case SETPOS:   return OK;

    case GETPOS:   return OK;

    case CLRSCR:   return OK;

    default:       return SYSERR;
    }
  return SYSERR;
}
