import java.util.TreeMap;
import java.util.Map.Entry;

import net.tinyos.prowler.GaussianRadioModel;
import net.tinyos.prowler.Node;
import net.tinyos.prowler.RadioModel;
import net.tinyos.prowler.Simulator;

/*
 * Some assumptions about this class 
 * - This class requires TrailNodes (since there are mobility related optimizations)
 * - Too fast movement can cause unpredictable behavior (if the neighborhood is updated 
 * faster than the message duration, for instance there may be similar noise build-up)
 * - Two scenarios constitute the problem:
 *   a) a node moving out of range during transmission
 *   b) a node getting into range during transmission 
 * 'a' case requires early termination of transmission 
 * 'b' case just ignores the new transmission 
 */
public class MobileGaussianRadioModel extends GaussianRadioModel
{
	long lastRadioModelUpdate;
	public MobileGaussianRadioModel(Simulator sim)
	{
		super(sim);
		lastRadioModelUpdate=Long.MIN_VALUE;
	}

	@Override
	protected net.tinyos.prowler.RadioModel.Neighborhood createNeighborhood()
	{
		return new Neighborhood();
	}

	@Override
	public void updateNeighborhoods()
	{
        Node node1 = sim.firstNode;
    	if (((MobileGaussianRadioModel.Neighborhood)node1.getNeighborhood()).myNode==null)
    	{
	        while (node1 != null)
	        {	        	
	        	((MobileGaussianRadioModel.Neighborhood)node1.getNeighborhood()).myNode=(TrailNode) node1;
	            node1 = node1.nextNode;
	        }
    	}
/*		
        // count nodes
        int nodeNum = 0;
        node1 = sim.firstNode;
        while (node1 != null){
            node1 = node1.nextNode;
            ++nodeNum;
        }
        
        Node[][] neighbors = new Node[nodeNum][nodeNum];
        int [] count=new int[nodeNum];
        double[][] staticFadings = new double[nodeNum][nodeNum];
                        
		node1 = sim.firstNode;
		int i=0;
		while (node1 != null)
		{
			count[i]=0;
            Node node2 = sim.firstNode;
			
			while (node2 != null)
			{
				if (node1!=node2)
				{
					double staticRadioStrength = getStaticFading(node1, node2);
					if ( staticRadioStrength >= radioStrengthCutoff)
					{
	                    neighbors[i][count[i]] = node2;
	                    staticFadings[i][count[i]] = staticRadioStrength;                    
	                    count[i]++;
					}
				}
				node2 = node2.nextNode;
			}	
			node1 = node1.nextNode;
			i++;	
		}
		
*/		node1 = sim.firstNode;
		
		while (node1!=null)
		{
			Neighborhood n=(Neighborhood)node1.getNeighborhood();
			n.update();
			node1=node1.nextNode;
		}
		
		lastRadioModelUpdate=sim.getSimulationTime();
		
/*		Neighborhood neighborhood = (Neighborhood)node1.getNeighborhood();
		neighborhood.updateAll(neighbors, staticFadings, i);*/

	}
	
	class NeighborhoodRecord
	{
		double dynamicStrength;
		double staticFading;
		public NeighborhoodRecord(double staticFading)
		{
			dynamicStrength=0;
			this.staticFading=staticFading;
		}
	}

	/**
	 * This class stores all the node related data the GaussianRadioModel needs, 
	 * this includes an array of neighboring notes, the static fading and 
	 * the dynamic strentgh as well for every neighboring nodes plus the entity
	 * being transmitted by the node. 
	 */
	protected class Neighborhood extends RadioModel.Neighborhood
	{
		TreeMap<Node,NeighborhoodRecord> neighbors;
		Object stream;
		TrailNode myNode;
		public Neighborhood()
		{
			neighbors=new TreeMap<Node, NeighborhoodRecord>();
			stream=null;
		}
		@Override
		protected void beginTransmission(double strength, Object stream)
		{
			this.stream=stream;
			for (Entry<Node,NeighborhoodRecord> e:neighbors.entrySet())
			{
				Node n=e.getKey();
				NeighborhoodRecord nr=e.getValue();
				double dynamicStrength = getDynamicStrength(strength, nr.staticFading);
				nr.dynamicStrength=dynamicStrength;
				n.receptionBegin(dynamicStrength, stream);
			}
		}
		@Override
		protected void endTransmission()
		{
			for (Entry<Node,NeighborhoodRecord> e:neighbors.entrySet())
			{
				Node n=e.getKey();
				NeighborhoodRecord nr=e.getValue();
				n.receptionEnd(nr.dynamicStrength,stream);
			}
			stream=null;
		}
		
		protected void update()
		{
			TrailNode n=(TrailNode)sim.firstNode;
			while (n!=null)
			{
				if (n!=myNode && (myNode.lastLocationUpdateTime > lastRadioModelUpdate || n.lastLocationUpdateTime>lastRadioModelUpdate))
				{
					double staticRadioStrength=0;
					if (myNode.getDistanceSquare(n)<2721) // 2721 is a magic number for radio strength cutoff
						staticRadioStrength= getStaticFading(myNode, n);
					if ( staticRadioStrength >= radioStrengthCutoff)
					{
						if (neighbors.containsKey(n))
						{
							neighbors.get(n).staticFading=staticRadioStrength;
						}
						else
						{
							// new connection
							neighbors.put(n, new NeighborhoodRecord(staticRadioStrength));
							// dynamic strength will be 0 so no problem there 
						}
					}
					else
					{
						if (neighbors.containsKey(n))
						{
							// remove this connection
							NeighborhoodRecord nr=neighbors.remove(n);
							if (myNode.isTransmitting())
							{
								n.receptionEnd(nr.dynamicStrength,stream);
							}	
						}
					}
				}
				n=(TrailNode)n.nextNode;
			}
		}
	}
}
