import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.event.*;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.awt.*;
import java.lang.reflect.*;
import java.text.DecimalFormat;
import java.util.*;

class TrailFrame extends JFrame implements ActionListener, Runnable, ChangeListener, Printable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -7646442265027985083L;
	
	TrailDisplay td;
	Thread t;
	boolean isRunning;
	TrailKernel krn;
	int simSpeed;
	
	JButton btnStep;
	JButton btnRun;
	JButton btnFastForward;
	JButton btnSendMail;
	JButton btnPrint;
	JSlider jsSimSpeed;
	JTabbedPane tabPane;
	JScrollPane statsTablePanel;
	JTable statsTable;
	JScrollPane infoTablePanel;
	JTable infoTable;
	JScrollPane displayOptionsTablePanel;
	JTable displayOptionsTable;
	
	class VectorTableModel extends AbstractTableModel
	{
		private static final long serialVersionUID = -5780782373322308887L;
		private Vector<String> columnNames;
		private Vector<Object[]> data;
		private boolean fixColumnType;
		
		public VectorTableModel(String [] names,boolean fixColumnType)
		{
			columnNames=new Vector<String>();
			data=new Vector<Object []>();
			for (String s:names)
				columnNames.add(s);
			fireTableChanged(new TableModelEvent(this));
			this.fixColumnType=fixColumnType;
		}
		
		public VectorTableModel(String [] names)
		{
			this(names,true);
		}

		public void clear()
		{
			data.clear();
			fireTableChanged(new TableModelEvent(this));
		}
		
		public void addRow(Object ... objects)
		{
			data.add(objects);
			fireTableChanged(new TableModelEvent(this));
		}
		
		public int getColumnCount() 
		{
			return columnNames.size();
		}
		
		public int getRowCount() {
			return data.size();
		}
		
		public String getColumnName(int col) {
		return columnNames.get(col);
		}
		
		public Object getValueAt(int row, int col) {
		return data.get(row)[col];
		}
		
		/*
		* JTable uses this method to determine the default renderer/
		* editor for each cell.  If we didn't implement this method,
		* then the last column would contain text ("true"/"false"),
		* rather than a check box.
		*/
		public Class<?> getColumnClass(int c) 
		{
			if (fixColumnType)
				return Object.class;
			else
				return getValueAt(0, c).getClass();
		}
		
		
		/*
		* Don't need to implement this method unless your table's
		* editable.
		*/
		public boolean isCellEditable(int row, int col) 
		{
		//Note that the data/cell address is constant,
		//no matter where the cell appears onscreen.
			if (col < 1) 
			{
				return false;
			} 
			else 
			{
				return true;
			}
		}
		
		/*
		* Don't need to implement this method unless your table's
		* data can change.
		*/
		public void setValueAt(Object value, int row, int col) 
		{

		data.get(row)[col] = value;
		fireTableCellUpdated(row, col);
		
		}
		
	}
	
	class KernelBooleanTableModel extends AbstractTableModel
	{
		private static final long serialVersionUID = 8137885804676988840L;
		private Vector<String> columnNames;
		private Vector<Field> data;
		private TrailKernel krn;
		
		public KernelBooleanTableModel(String [] names, TrailKernel krn)
		{
			this.krn=krn;
			columnNames=new Vector<String>();
			for (String s:names)
				columnNames.add(s);
			data=new Vector<Field>();
			Field [] fields=krn.getClass().getDeclaredFields();
			for (int i=0;i<fields.length;i++)
			{
				if (fields[i].getGenericType().toString().equals("boolean"))
				{
					data.add(fields[i]);
				}
			}
			fireTableChanged(new TableModelEvent(this));
		}
		
		public void clear()
		{
			fireTableChanged(new TableModelEvent(this));
		}
		
		public int getColumnCount() 
		{
			return columnNames.size();
		}
		
		public int getRowCount() {
			return data.size();
		}
		
		public String getColumnName(int col) {
		return columnNames.get(col);
		}
		
		public Object getValueAt(int row, int col) 
		{
			if (col==0)
			{
				return data.get(row).getName();
			}
			else
			{		
				try {
					return data.get(row).get(krn);
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			}
			return null;
		}
		
		/*
		* JTable uses this method to determine the default renderer/
		* editor for each cell.  If we didn't implement this method,
		* then the last column would contain text ("true"/"false"),
		* rather than a check box.
		*/
		public Class<?> getColumnClass(int c) 
		{
			return getValueAt(0, c).getClass();
		}
		
		
		/*
		* Don't need to implement this method unless your table's
		* editable.
		*/
		public boolean isCellEditable(int row, int col) 
		{
		//Note that the data/cell address is constant,
		//no matter where the cell appears onscreen.
			if (col < 1) 
			{
				return false;
			} 
			else 
			{
				return true;
			}
		}
		
		/*
		* Don't need to implement this method unless your table's
		* data can change.
		*/
		public void setValueAt(Object value, int row, int col) 
		{
			try {
				data.get(row).set(krn,value);
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			fireTableCellUpdated(row, col);
		}
		
	}	


	void updateInfoTable()
	{
		VectorTableModel tm=(VectorTableModel )infoTable.getModel();
		if (td.nearest!=null)
		{
			DecimalFormat formatter = new DecimalFormat("#.######");
			long nextId=-1;
			if (td.nearest.next!=null)
				nextId=td.nearest.next.id;
			TrailNode tnode=(TrailNode)td.nearest.trailApp.getNode();
			Object[][] data={{"id",td.nearest.id},
			{"handoff",td.nearest.handoffCount},
			{"disconnects",td.nearest.badHandoffCount},
			{"con. ratio(S)",1-((double)td.nearest.badHandoffCount/td.nearest.handoffCount)},
			{"con. ratio(T)",td.nearest.connRatio},
			{"con. ratio(I,T)",td.nearest.connIndirectRatio},
			{"handoff ratio(S)",((double)td.nearest.handoffCount)/krn.handoffcount},
			{"handoff ratio(T)",td.nearest.handoffRatio},
			{"next",nextId},
			{"area",td.nearest.voronoiCellArea},
			{"circum",td.nearest.voronoiCellCircum},
			{"bwAllocated",td.nearest.bwAllocated},
			{"queueSize",td.nearest.getBufferedPacketCount()},
			{"energyUse",td.nearest.energyUsed},
			{"noiseStrength",formatter.format(tnode.getNoiseLevel())},
			{"activeTransmissions",tnode.activeReceptionCount},
			{"msgSent",tnode.getTrailApp().messagesSent},
			{"msgRecv",tnode.getTrailApp().messagesReceived},
			{"generated pkgs",tnode.getTrailApp().currentPacketIndex}};
	
			if (tm.getRowCount()!=data.length)
			{
				tm.clear();
				for (int i=0;i<data.length;i++)
				{
					tm.addRow(data[i]);
				}
			}
			else
			{
				for (int i=0;i<data.length;i++)
				{
					tm.setValueAt(data[i][1], i, 1);
				}
			}
		}
	}
	
	void createDisplayOptionsTable()
	{
		String[] columnNames={"Variable",""};
		displayOptionsTable = new JTable(new KernelBooleanTableModel(columnNames,krn));
		displayOptionsTable.setPreferredScrollableViewportSize(new Dimension(500, 250));
		displayOptionsTable.getModel().addTableModelListener(new TableModelListener()
		{
			public void tableChanged(TableModelEvent arg0) 
			{
				KernelBooleanTableModel tm=(KernelBooleanTableModel)arg0.getSource();
				for (int i=arg0.getFirstRow();i<=arg0.getLastRow();i++)
				{
					if (((String)tm.getValueAt(i, 0)).compareTo("colorCells")==0 ||
						((String)tm.getValueAt(i, 0)).compareTo("showCellBorders")==0)
						{
							td.img=null;
						}
				}
				repaint();
			}		
		});
		TableColumn tc=displayOptionsTable.getColumn("Variable");
		tc.setPreferredWidth(250);
		tc=displayOptionsTable.getColumn("");
		tc.setPreferredWidth(40);
//		infoTable.setEnabled(false);
	}
	
	void createInfoTable()
	{
		String[] columnNames={"Variable","Value"};
		infoTable = new JTable(new VectorTableModel(columnNames));
		infoTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
		infoTable.setEnabled(false);
		updateInfoTable();
	}
	
	void updateStatsTable()
	{
		double mse=0;
		for (GeomNode n:krn.nodes)
		{
			double simratio=((double)n.handoffCount)/krn.handoffcount;
			mse+=(simratio-n.handoffRatio)*(simratio-n.handoffRatio);
		}
		mse/=krn.nNodes;
		double averageDelay=0;
		if (krn.packetsDelivered>0)
			averageDelay=krn.totalDelay/krn.packetsDelivered;
		VectorTableModel tm=(VectorTableModel )statsTable.getModel();
		Object[][] data={{"time",krn.time},
		{"conScore(T)",krn.connectionScore},
		{"conScore(I,T)",krn.indirectConnectionScore},
		{"conScore(S)",1-((double)krn.disconnectcount/krn.handoffcount)},
		{"disconnects",krn.disconnectcount},
		{"handoffs",krn.handoffcount},
		{"handoff mse",mse},
		{"useIndirect",krn.useIndirectHandoff},
		{"seed",krn.seed},
		{"range",krn.range},
		{"badEdge",krn.badEdgeRatio},
		{"packetsGenerated",krn.packetsGenerated},
		{"packetsDropped",krn.packetsDropped},
		{"packetsDelivered",krn.packetsDelivered},
		{"messagesSent",krn.messagesSent},
		{"maxEnergyUse",krn.maxEnergyUse},
		{"lifetime(days)",krn.expectedLifeTime},
		{"averageDelay",averageDelay},
		{"Delivery ratio",krn.deliveryRatio},
		{"Throughput",krn.throughput}
		};

		if (tm.getRowCount()!=data.length)
		{
			tm.clear();
			for (int i=0;i<data.length;i++)
			{
				tm.addRow(data[i]);
			}
		}
		else
		{
			for (int i=0;i<data.length;i++)
			{
				tm.setValueAt(data[i][1], i, 1);
			}
		}
	}
	
	void createStatsTable()
	{
		String [] columnNames={"Metric","Value"};
		statsTable = new JTable(new VectorTableModel(columnNames));
		statsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
		//statsTable.setEnabled(false);
		updateStatsTable();
	}
	
	public TrailFrame(TrailKernel krn)
	{
		super("Data Spider Simulator v0.99");
		this.krn=krn;
		isRunning=false;
		t=new Thread(this);
		t.start();
		simSpeed=1;

		this.setBounds(0, 0, 1000, 700);
		this.getContentPane().setLayout(null);
		td=new TrailDisplay(this);
		td.setBounds(0, 0, krn.width, krn.height);
		this.getContentPane().add(td);
		if (TrailKernel.krn.isApplet)
			this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		else
			this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		btnStep=new JButton("Step");
		btnStep.setBounds(0,krn.height+5,140,30);
		btnStep.addActionListener(this);
		this.getContentPane().add(btnStep);

		btnRun=new JButton("Run");
		btnRun.setBounds(150,krn.height+5,140,30);
		btnRun.addActionListener(this);
		this.getContentPane().add(btnRun);
		
		btnFastForward=new JButton("Fast Forward 1000s");
		btnFastForward.setBounds(300, krn.height+5, 140,30);
		btnFastForward.addActionListener(this);
		this.getContentPane().add(btnFastForward);
		
		btnSendMail=new JButton("Send Mail To Dr. D.");
		btnSendMail.setBounds(650, krn.height+5, 140,30);
		btnSendMail.addActionListener(this);
//		this.getContentPane().add(btnSendMail);
		
		btnPrint=new JButton("Print");
		btnPrint.setBounds(0,krn.height+5+30,140,30);
		btnPrint.addActionListener(this);
		this.getContentPane().add(btnPrint);

		
		jsSimSpeed = new JSlider(JSlider.HORIZONTAL,
                0, 100, simSpeed);
		jsSimSpeed.addChangeListener(this);

		jsSimSpeed.setMajorTickSpacing(10);
		jsSimSpeed.setMinorTickSpacing(5);
		jsSimSpeed.setPaintTicks(true);
		jsSimSpeed.setBounds(450, krn.height+5, 200,50);
		this.getContentPane().add(jsSimSpeed);
		
		createStatsTable();
		createInfoTable();
		createDisplayOptionsTable();
		statsTablePanel=new JScrollPane(statsTable);
		infoTablePanel=new JScrollPane(infoTable);
		displayOptionsTablePanel=new JScrollPane(displayOptionsTable);
		tabPane=new JTabbedPane();
		tabPane.addTab("stats", statsTablePanel);
		tabPane.addTab("info", infoTablePanel);
		tabPane.addTab("display", displayOptionsTablePanel);
		tabPane.setBounds(krn.width,0,1000-krn.width-10,krn.height);
		this.getContentPane().add(tabPane);
	}
	

	public void actionPerformed(ActionEvent e) 
	{
		if (e.getSource()==btnStep)
		{
//			for (int i=0;i<10;i++)
			{
				krn.step();
				doUpdates();
			}
		}
		else if (e.getSource()==btnRun)
		{
			isRunning=!isRunning;
			if (!isRunning)
				btnRun.setText("Run");
			else
				btnRun.setText("Stop");
		}
		else if (e.getSource()==btnFastForward)
		{
			boolean runState=isRunning;
			if (isRunning)
			{
				isRunning=false;
			}
			btnRun.setText("Fast Forwarding");
			repaint();
			btnRun.setEnabled(false);
			for (int i=0;i<10000;i++)
				krn.step();
			if (runState)
			{
				isRunning=true;
				btnRun.setText("Stop");
			}
			else
			{
				isRunning=false;
				btnRun.setText("Run");
			}	
			btnRun.setEnabled(true);
			doUpdates();
		}
		else if (e.getSource()==btnSendMail)
		{
			// uncomment below to enable it 
/*			Runtime mycommand=java.lang.Runtime.getRuntime();
			try {
				mycommand.exec("c:\\cygwin\\bin\\bash -c \"./sendmail.py &>a.txt \"");
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}*/ 
		}
		else if (e.getSource()==btnPrint)
		{
			if (krn.printAll)
			{
				doPrint();
			}
			else
				td.doPrint();
		}
	}
	
	void doUpdates()
	{
		updateStatsTable();
		updateInfoTable();
		repaint();	
	}

	public void run() 
	{
		long tm = System.currentTimeMillis();
		long delay=50;
		try
		{
			do
			{
				tm += delay;
				Thread.sleep(Math.max(0, tm - System.currentTimeMillis()));
				if (isRunning)
				{
					for (int i=0;i<simSpeed;i++)
						krn.step();
					doUpdates();
				}
			}while (true);
		}
		catch(InterruptedException e)
		{
			// quit gracefully
		}
	}

	public void stateChanged(ChangeEvent e) 
	{
		JSlider js=(JSlider)e.getSource();
		simSpeed=js.getValue();
	}
	
	public int print(Graphics g, PageFormat pf, int page) throws PrinterException
	{
		
		if (page > 0)
		{ /* We have only one page, and 'page' is zero-based */
			return NO_SUCH_PAGE;
		}
		
		/*
		 * User (0,0) is typically outside the imageable area, so we must
		 * translate by the X and Y values in the PageFormat to avoid clipping
		 */
		Graphics2D g2d = (Graphics2D) g;
		double scaledHeight=((double)getHeight())/getWidth()*pf.getImageableWidth();
		g2d.setClip((int)pf.getImageableX(), (int)pf.getImageableY(), (int)pf.getWidth(), (int)scaledHeight);
		g2d.translate(pf.getImageableX(), pf.getImageableY());
		double scale=((double)pf.getImageableWidth())/getWidth();
		g2d.scale(scale, scale);
		
		/* Now we perform our rendering */
		//g.drawString("Hello world!", 100, 100);
		boolean useFast=td.useFastPaint;
		td.useFastPaint=false;
		this.paintAll(g2d);
		td.useFastPaint=useFast;
		
		/* tell the caller that this page is part of the printed document */
		return PAGE_EXISTS;
	}

	public void doPrint()
	{
		System.out.println("Begining Print...");
	    PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                 job.print();
            } catch (PrinterException ex) {
             /* The job did not successfully complete */
            }
        }   
		System.out.println("Printing Complete");
	}

}


public class TrailApp 
{
	public static void main(String [] args)
	{
		TrailKernel krn;
//		double mean=0;
//		for (int i=0;i<50;i++)
//		{
////			System.out.print("Seed= "+(i+42)+"  ");
//			krn=new TrailKernel(i+42,args);
//			mean+=krn.connectionScore;
//			//krn.printStats();
//		}
//		mean/=50;
//		System.out.println("Mean="+mean);
			
		krn=new TrailKernel(args);
		if (!krn.hideDisplay)
		{
			krn.computeCosmetics();
			krn.printStats();
			TrailFrame tf=new TrailFrame(krn);
			tf.setVisible(true);
		}
		else
		{
			krn.simulate();
		}
	}
}
