import java.awt.*;
import net.tinyos.prowler.*;

public class TrailNode extends Mica2Node implements Comparable<TrailNode>
{
	long lastLocationUpdateTime;
	int activeReceptionCount;
	public TrailNode(Simulator sim, RadioModel radioModel)
	{
		super(sim, radioModel);
		// these are for the BMAC model
		sendMinBackOffTime= 3600;
		sendRandomBackOffTime = 3000;
		sendTransmissionTime = 5107;
		activeReceptionCount=0;
	}
	
	public void display(Display disp){
		Graphics g = disp.getGraphics();
		int      x = disp.x2ScreenX(this.x);
		int      y = disp.y2ScreenY(this.y);
               
		if( sending ){                    
			g.setColor( Color.blue );
		}else if( receiving ){
			if( corrupted )
				g.setColor( Color.red );
			else
				g.setColor( Color.green );                            
		}else{
				g.setColor( Color.black );
		}
		//g.fillOval( x-3, y-3, 5, 5 );
		g.drawString(""+id, x, y);
	}
	public String toString()
	{
		return "TrailNode["+getId()+"]";
	}
	
	public int compareTo(TrailNode o)
	{
		if (id<o.id)
			return -1;
		else if (id>o.id)
			return 1;
		return 0;
	}

	@Override
	public void setPosition(double x, double y, double z)
	{
		lastLocationUpdateTime=simulator.getSimulationTime();
		super.setPosition(x, y, z);
	}
	
	public boolean isTransmitting()
	{
		return transmitting;
	}
	
	public TrailApplication getTrailApp()
	{
		return (TrailApplication)getApplication(TrailApplication.class);
	}
	
	public Object getLastMessageSent()
	{
		return message;
	}
	
	public double getNoiseLevel()
	{
		return noiseStrength;
	}

/*	@Override
	public void receptionBegin(double strength, Object stream)
	{
		super.receptionBegin(strength, stream);
		activeReceptionCount++;
	}

	@Override
	public void receptionEnd(double strength, Object stream)
	{
		super.receptionEnd(strength, stream);
		activeReceptionCount--;
	}*/
}