import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.*;
import java.util.StringTokenizer;

import javax.swing.*;


public class DataSpiderApplet extends JApplet
{
	private static final long serialVersionUID = 6802011946561355921L;
	String [] commandline;
	JTextArea taHelp;
	JTextArea taOptions;
	JTextArea taResults;
	JButton btnRun;
	JButton createOptions;
	public DataSpiderApplet() 
	{
		btnRun=new JButton("Run Simulator");
		btnRun.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) 
			{
				runTest();
			}
		});
		taHelp=new JTextArea();
		JScrollPane taPane=new JScrollPane(taHelp);
		getHelp();
		taOptions=new JTextArea();
		taResults=new JTextArea();
		taResults.setEditable(false);
		getContentPane().setLayout(new BorderLayout());
		JPanel p=new JPanel();
		p.setLayout(new GridLayout(3,1));
		JPanel p2=new JPanel();
		p2.setLayout(new BorderLayout());
		p2.add(new JLabel("Help :"),BorderLayout.NORTH);
		p2.add(taPane,BorderLayout.CENTER);
		
		JPanel p3=new JPanel();
		p3.setLayout(new BorderLayout());
		p3.add(new JLabel("Options :"),BorderLayout.NORTH);
		p3.add(taOptions,BorderLayout.CENTER);
		
		JPanel p4=new JPanel();
		p4.setLayout(new BorderLayout());
		p4.add(new JLabel("Results :"),BorderLayout.NORTH);
		p4.add(new JScrollPane(taResults),BorderLayout.CENTER);

		p.add(p2);
		p.add(p3);
		p.add(p4);
		this.getContentPane().add(p,BorderLayout.CENTER);
		this.getContentPane().add(btnRun,BorderLayout.SOUTH);
	}
	
	void getHelp()
	{
		GeomNode.FIRST_FREE_ID=0;
		TrailKernel t=new TrailKernel(new String[0]);
		String []help=t.getHelpText();
		for (String str:help)
		{
			if (str!=null)
				taHelp.append(str+"\n");
		}
	}
	
	void updateResults(String []res)
	{
		taResults.setText("");
		for (String str:res)
		{
			if (str!=null)
				taResults.append(str+"\n");
		}
	}
	
	void runTest()
	{
		StringTokenizer st=new StringTokenizer(taOptions.getText());
		commandline=new String[st.countTokens()+2];
		int n=st.countTokens();
		int i=0;
		while (st.hasMoreTokens())
			commandline[i++]=st.nextToken();
		commandline[n]="-isApplet";
		commandline[n+1]="true";
		GeomNode.FIRST_FREE_ID=0;
		TrailApp.main(commandline);
		if (TrailKernel.krn.hideDisplay)
		{
			updateResults(TrailKernel.krn.getParameterText());
		}
	}
}
