/**
 * @file etherClose.c
 * @provides etherClose
 *
 * $Id: etherClose.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <ether.h>
#include <memory.h>
#include <bufpool.h>
#include <stdlib.h>
#include <interrupt.h>
#include <thread.h>

/**
 * Close an ethernet device.
 * @param pdev ether device table entry
 * @return OK if device is closed properly, otherwise SYSERR
 */
devcall etherClose(device * pdev)
{
    irqmask im;
    struct ether *peth = NULL;
    struct bcm4713 *pecsr = NULL;

    peth = &ethertab[pdev->minor];
    pecsr = peth->csr;

    /* flag interface as down */
    peth->state = ETH_STATE_DOWN;

    im = disable();

    /* disable ether interrupt source */
    pecsr->interruptMask = 0x0;
    pecsr->interruptStatus = 0x0;

    restore(im);

    etherControl(pdev, ETH_CTRL_RESET, 0, 0);

    bfpfree(peth->inPool);
    bfpfree(peth->outPool);

    return OK;
}
