/**
 * @file vlanClose.c
 * @provides vlanClose
 *
 * $Id: vlanClose.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <ether.h>
#include <bufpool.h>
#include <stdlib.h>

/**
 * Close a virtual ethernet device.
 * @param pdev ether device table entry
 * @return OK if device is closed properly
 */
devcall vlanClose(device * pdev)
{
    struct ether *peth = NULL;

    peth = &ethertab[pdev->minor];

    /* flag interface as down */
    peth->state = ETH_STATE_DOWN;

    return OK;
}
