/**
 * @file vlanInit.c
 * @provides vlanInit
 *
 * $Id: vlanInit.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <kernel.h>
#include <stdio.h>
#include <stdlib.h>
#include <device.h>
#include <ether.h>
#include <vlan.h>
#include <memory.h>
#include <backplane.h>
#include <bcm4713.h>
#include <nvram.h>

/**
 * Initialize virtual ethernet device structures.
 * @param pdev TTY device table entry
 * @return OK if device is intialized successfully
 */
devcall vlanInit(device * pdev)
{
    struct ether *peth;

    /* Initialize structure pointers */
    peth = &ethertab[pdev->minor];
    bzero(peth, sizeof(struct ether));
    pdev->controlblk = peth;
    peth->dev = pdev;
    peth->csr = (struct bcm4713 *)pdev->csr;
    /* Physical ethernet device to which the VLAN attaches */
    peth->phy = &devtab[ETH0];

    peth->errors = 0;
    peth->state = ETH_STATE_DOWN;
    peth->rxPending = ETH_RX_RING_ENTRIES;
    peth->txPending = ETH_TX_RING_ENTRIES;
    peth->mtu = ETH_MTU;

    peth->isema = semcreate(0);
    peth->istart = 0;
    peth->icount = 0;
    peth->ovrrun = 0;
    peth->rxOffset = sizeof(struct rxHeader);

    /* Lookup MAC in NVRAM, and store it in ether dev struct. */
    /* Modify first octet with device minor and set local admin bit */
    colon2mac(nvramGet("et0macaddr"), peth->devAddress);
    peth->devAddress[0] |= ((uchar)pdev->minor << 2) | ETH_LOCAL_MAC;

    peth->interruptMask = IMASK_DEF;

    /* As there is only one DMA ring for the physical ethernet, and
     * none for virtual interfaces, certain values in the ether struct
     * are set to invalid
     */
    peth->rxBufs = (struct ethPktBuffer **)ETH_INVALID;
    peth->txBufs = (struct ethPktBuffer **)ETH_INVALID;
    peth->rxRing = (struct dmaDescriptor *)ETH_INVALID;
    peth->txRing = (struct dmaDescriptor *)ETH_INVALID;

    return OK;
}
