/**
 * @file vlanOpen.c
 * @provides vlanOpen
 *
 * $Id: vlanOpen.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <ether.h>
#include <memory.h>
#include <bufpool.h>
#include <stdlib.h>
#include <interrupt.h>

/**
 * Open a virtual ethernet device for use
 * @param  pdev ethernet device table entry
 * @return OK if opened properly, otherwise SYSERR
 */
devcall vlanOpen(device * pdev)
{
    struct ether *peth;

    /* Initialize structure pointers */
    peth = &ethertab[pdev->minor];

    /* Rx and Tx buffers associated with hardware device */
    peth->inPool = ETH_INVALID;
    peth->outPool = ETH_INVALID;
    peth->state = ETH_STATE_UP;

    etherControl(pdev, ETH_CTRL_SET_MAC, (ulong)peth->devAddress, 0);

    return OK;
}
