/**
 * @file loopbackClose.c
 * @provides loopbackClose
 *
 * $Id: loopbackClose.c 1577 2008-10-03 18:19:26Z mschul $
 **/
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>
#include <stdlib.h>

/**
 * Close a loopback device.
 * @param pdev loopback device table entry
 * @return OK if loopback is closed properly, otherwise SYSERR
 **/
devcall loopbackClose(device * pdev)
{
    struct loopback *plbk;

    /* Setup and error check pointers to structures */
    plbk = (struct loopback *)pdev->controlblk;
    if (NULL == plbk)
    {
        return SYSERR;
    }

    pdev->controlblk = NULL;    /* Clear device IO block.       */

    /* free the semaphore */
    semfree(plbk->sem);

    return OK;
}
