/**
 * @file     loopbackGetc.c
 * @provides loopbackGetc
 *
 * $Id: loopbackGetc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <semaphore.h>
#include <loopback.h>
#include <stdio.h>
#include <interrupt.h>

/**
 * Get a character from the loopback buffer
 * @param pdev Loopback device
 * @return character from buffer
 */
devcall loopbackGetc(device * pdev)
{
    irqmask im;
    struct loopback *plbk;
    int i;

    if (NULL == pdev)
    {
        return SYSERR;
    }

    plbk = (struct loopback *)pdev->controlblk;
    if (NULL == plbk)
    {
        return SYSERR;
    }

    /* wait until the buffer has data */
    wait(plbk->sem);

    im = disable();

    i = plbk->index;
    plbk->index = (i + 1) % LOOP_BUFFER;

    restore(im);

    /* consume the data */
    return plbk->buffer[i];
}
