/**
 * @file     loopbackInit.c
 * @provides loopbackInit
 *
 * $Id: loopbackInit.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>
#include <stdlib.h>

struct loopback looptab[NLOOPBACK];

/**
 * Initialize loopback device
 * @param pdev 
 * @return OK on open
 */
devcall loopbackInit(device * pdev)
{
    struct loopback *plbk = NULL;

    /* Check valid device */
    if (NULL == pdev)
    {
        return SYSERR;
    }

    pdev->controlblk = NULL;
    plbk = &looptab[pdev->minor];
    plbk->index = 0;

    return OK;
}
