/**
 * @file     loopbackOpen.c
 * @provides loopbackOpen
 * 
 * $Id: loopbackOpen.c 1577 2008-10-03 18:19:26Z mschul $
 **/
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>
#include <stdlib.h>

/**
 * Open a loopback device. 
 * @param pdev loopback device table entry
 * @return OK if loopback is opened properly, otherwise SYSERR
 */
devcall loopbackOpen(device * pdev)
{
    struct loopback *plbk = NULL;

    /* Check if valid device pointer */
    if (NULL == pdev)
    {
        return SYSERR;
    }

    /* Check if loopback is already open */
    if (NULL != pdev->controlblk)
    {
        return OK;
    }

    /* Set up pointer to loopback */
    plbk = &looptab[pdev->minor];

    /* Link loopback record with device table entry */
    pdev->controlblk = plbk;

    /* Gather new semaphore */
    plbk->sem = semcreate(0);

    /* Zero out the buffer */
    bzero(plbk->buffer, LOOP_BUFFER);

    return OK;
}
