/**
 * @file     loopbackPutc.c
 * @provides loopbackPutc
 *
 * $Id: loopbackPutc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>
#include <semaphore.h>
#include <interrupt.h>

/**
 * Put a character onto the loopback buffer
 * @param pdev Loopback device
 * @param ch character to output
 * @return OK if character was written successfully
 */
devcall loopbackPutc(device * pdev, char ch)
{
    struct loopback *plbk;
    irqmask im;
    int i;

    if (NULL == pdev)
    {
        return SYSERR;
    }

    plbk = (struct loopback *)pdev->controlblk;
    if (NULL == plbk)
    {
        return SYSERR;
    }

    im = disable();

    /* Ensure room in buffer */
    if (LOOP_BUFFER <= semcount(plbk->sem))
    {
        restore(im);
        return SYSERR;
    }

    i = (plbk->index + semcount(plbk->sem)) % LOOP_BUFFER;
    plbk->buffer[i] = ch;

    /* signal that more data is on the buffer */
    signal(plbk->sem);

    restore(im);

    return OK;
}
