/**
 * @file     loopbackRead.c
 * @provides loopbackRead
 *
 * $Id: loopbackRead.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>

/**
 * Read characters from a loopback.
 * @param pdev 
 * @param buf buffer for read characters
 * @param len size of the buffer
 * @return number of characters read, EOF if end of file was reached
 */
devcall loopbackRead(device * pdev, void *buf, uint len)
{
    uint i;
    char *buffer = buf;

    for (i = 0; i < len; i++)
    {
        buffer[i] = loopbackGetc(pdev);
    }

    return i;
}
