/**
 * @file     loopbackWrite.c
 * @provides loopbackWrite
 *
 * $Id: loopbackWrite.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <loopback.h>

/**
 * Write a character to the loopback. 
 * @param pdev 
 * @param buf buffer of characters to output
 * @param len size of the buffer
 * @return count of characters output
 */
devcall loopbackWrite(device * pdev, void *buf, uint len)
{
    uint i;
    char *buffer = buf;

    for (i = 0; i < len; i++)
    {
        /* If char wasn't put into buffer return SYSERR */
        if (SYSERR == loopbackPutc(pdev, buffer[i]))
        {
            return i;
        }
    }

    return i;
}
