/**
 * @file ttyClose.c
 * @provides ttyClose
 *
 * $Id: ttyClose.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>
#include <stdlib.h>

/**
 * Close a TTY device.
 * @param pdev TTY device table entry
 * @return OK if TTY is closed properly, otherwise SYSERR
 */
devcall ttyClose(device * pdev)
{
    struct tty *ttyptr;

    /* Setup and error check pointers to structures */
    ttyptr = (struct tty *)pdev->controlblk;
    if (NULL == ttyptr)
    {
        return SYSERR;
    }

    bzero(ttyptr, sizeof(struct tty));  /* Clear TTY structure.         */
    pdev->controlblk = NULL;    /* Clear device IO block.       */
    return OK;
}
