/**
 * @file ttyControl.c
 * @provides ttyControl
 *
 * $Id: ttyControl.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>

/**
 * Control function for TTY pseudo devices.
 * @param pdev TTY device table entry
 * @param func control function to execute
 * @param arg1 first argument for the control function
 * @param arg2 second argument for the control function
 * @return the result of the control function
 */
devcall ttyControl(device * pdev, int func, long arg1, long arg2)
{
    struct tty *ttyptr;
    device *phw;
    char old;

    /* Setup and error check pointers to structures */
    ttyptr = (struct tty *)pdev->controlblk;
    if (NULL == ttyptr)
    {
        return SYSERR;
    }

    phw = ttyptr->tty_phw;
    if (NULL == phw)
    {
        return SYSERR;
    }

    switch (func)
    {
        /* Set input flags: arg1 = flags to set      */
        /* return old value of flags                 */
    case TTY_CTRL_SET_IFLAG:
        old = ttyptr->iflags & arg1;
        ttyptr->iflags |= (arg1);
        return old;

        /* Clear input flags: arg1 = flags to clear  */
        /* return old value of flags                 */
    case TTY_CTRL_CLR_IFLAG:
        old = ttyptr->iflags & arg1;
        ttyptr->iflags &= ~(arg1);
        return old;

        /* Set output flags: arg1 = flags to set     */
        /* return old value of flags                 */
    case TTY_CTRL_SET_OFLAG:
        old = ttyptr->oflags & arg1;
        ttyptr->oflags |= (arg1);
        return old;

        /* Clear output flags: arg1 = flags to clear */
        /* return old value of flags                 */
    case TTY_CTRL_CLR_OFLAG:
        old = ttyptr->oflags & arg1;
        ttyptr->oflags &= ~(arg1);
        return old;
    }

    return SYSERR;
}
