/**
 * @file ttyGetc.c
 * @provides ttyGetc
 *
 * $Id: ttyGetc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <ctype.h>
#include <device.h>
#include <tty.h>

/**
 * Read a single character from a TTY.
 * @param pdev TTY device table entry
 * @return character read from TTY, or EOF
 */
devcall ttyGetc(device * pdev)
{
    char ch;
    int result = NULL;

    result = ttyRead(pdev, &ch, 1);

    if (1 != result)
    {
        return result;
    }

    return ch;
}
